/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractSecurityOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;

public class CreateOrganizationOperation
extends AbstractSecurityOperation {
    private static final String NAME = "create organization";

    public CreateOrganizationOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE ORGANIZATION").addActionParameter(new IdentifierParameter("Name"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DESCRIPTION", false).addParameter(new StringParameter("Description", Character.valueOf('\''), Character.valueOf('\'')))).setSyntaxHintSpace());
        this.syntax.setDescription("Creates a new organization in the Fabric.");
        this.syntax.setExamples("create organization Org1\ncreate organization Org2 description 'Example organization.'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Name").getValue(), statement.getParameter("Description").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        this.getSecurityManager(session).createOrganization(definition.organizationName, definition.description);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String organizationName;
        private String description;

        public Definition(String organizationName, String description) {
            super(CreateOrganizationOperation.NAME);
            this.organizationName = organizationName;
            this.description = description;
        }

        public String getOrganizationName() {
            return this.organizationName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

