/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractSecurityOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;

public class CreateGroupOperation
extends AbstractSecurityOperation {
    private static final String NAME = "create group";

    public CreateGroupOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE GROUP").addActionParameter(new IdentifierParameter("GroupName"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DESCRIPTION", false).addParameter(new StringParameter("Description", Character.valueOf('\''), Character.valueOf('\'')))).setSyntaxHintSpace());
        this.syntax.setDescription("Creates a new group in the Fabric.");
        this.syntax.setExamples("create group Group1\ncreate group Group2 description 'Example group.'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("GroupName").getValue(), statement.getParameter("Description").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        this.getSecurityManager(session).createGroup(definition.groupName, definition.description);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String groupName;
        private String description;

        public Definition(String groupName, String description) {
            super(CreateGroupOperation.NAME);
            this.groupName = groupName;
            this.description = description;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

