/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.runtime.mf.operation.SetParametersModifier;
import com.streamscape.runtime.mf.operation.security.AbstractUserOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.dispatcher.AbstractSecurityOperation;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.User;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.BooleanParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.value.StatementSetValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AlterUserOperation
extends AbstractUserOperation {
    public static final String NAME = "alter user";

    public AlterUserOperation() {
        super(false);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER USER").addActionParameter(new IdentifierParameter("Name"));
        this.syntax.addModifier(new CompoundModifier(false).addModifier(new Modifier("SET PASSWORD")).addModifier((AbstractModifier)new Modifier("OLD").addParameter(new StringParameter("OldPassword"))).addModifier((AbstractModifier)new Modifier("NEW").addParameter(new StringParameter("NewPassword"))));
        this.syntax.addModifier(new Modifier("RESET PASSWORD", false));
        this.syntax.addModifier((AbstractModifier)new Modifier("ORGANIZATION", false).addParameter((SyntaxParameter)new IdentifierParameter("Organization").setCompletionAdviser(new AbstractSecurityOperation.OrganizationsAdviser(this))));
        this.syntax.addModifier((AbstractModifier)new Modifier("ALIAS", false).addParameter(new StringParameter("Alias", Character.valueOf('\''), Character.valueOf('\''))));
        this.syntax.addModifier((AbstractModifier)new Modifier("DESCRIPTION", false).addParameter(new StringParameter("Description")));
        this.syntax.addModifier((AbstractModifier)new Modifier("DISTINGUISHED ENTITY", false).addParameter(new BooleanParameter("DistinguishedEntity")));
        this.syntax.addModifier((AbstractModifier)new Modifier("SUDO CAPABLE", false).addParameter(new BooleanParameter("SudoCapable")));
        this.syntax.addModifier((AbstractModifier)new Modifier("CREATE DROPBOX", false).addParameter(new BooleanParameter("DropBoxOwner")));
        this.syntax.addModifier(new SetParametersModifier("SET ATTRIBUTES", "Attributes", false));
        this.syntax.addModifier((AbstractModifier)new Modifier("REMOVE ATTRIBUTES", false).addParameter(new SetParameter("RemoveAttributes", new IdentifierParameter("Name"))));
        AlterUserOperation.addProfileSyntax(this.syntax, true);
        this.syntax.setDescription("Alters parameters of the specified user.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   set password         - Sets the user password.\n   reset password       - Resets the user password.\n   alias                - Alias of the user.\n   description          - Description of the user.\n   distinguished entity - Specifies if the user is a distinguished entity.\n   sudo capable         - Specifies if the user is sudo capable.\n   create dropbox       - Specifies if the user can create new DropBoxes.\n   set attributes       - Sets the specified list of attributes.\n                          This list consist of pairs <name> = '<value>' which must be separated by comma:\n                             name  - the name of the attribute.\n                             value - the value of the attribute.\n   remove attributes    - Removes the specified list of attributes.\n                          This list consist of attribute names which must be separated by comma.\n   profile              - Profile (vCard) of the user.\n   profile clear        - Clears the user profile (vCard).");
        this.syntax.setExamples("alter user Bob organization Org1\nalter user Bob alias 'Bobby'\nalter user Bob description 'Example'\nalter user Bob distinguished entity true set attributes (name1 = 'value1', name2 = 'value2')\nalter user Bob alias 'Bobby' description 'Example' sudo capable true set attributes (name = 'value')\nalter user Bob profile full name 'Bobby' role 'Developer' photo 'C:/Pictures/Bob.jpeg'\nalter user Bob reset password\nalter user Bob set password old 'OldPass' new 'NewPass'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        if (statement.getValuesCount() <= 2) {
            throw new ParsingException(this.getSyntaxErrorMessage("At least one parameter must be specified."));
        }
        Definition result = new Definition(statement, this.getSyntax(null));
        if (statement.existsParameter("Organization")) {
            result.setOrganization(statement.getParameter("Organization").getValue());
        }
        if (statement.existsParameter("Alias")) {
            result.setAlias(statement.getParameter("Alias").getValue());
        }
        if (statement.existsParameter("Description")) {
            result.setDescription(statement.getParameter("Description").getValue());
        }
        if (statement.existsParameter("DistinguishedEntity")) {
            result.setDistinguishedEntity(Boolean.parseBoolean(statement.getParameter("DistinguishedEntity").getValue()));
        }
        if (statement.existsParameter("SudoCapable")) {
            result.setSudoCapable(Boolean.parseBoolean(statement.getParameter("SudoCapable").getValue()));
        }
        if (statement.existsParameter("DropBoxOwner")) {
            result.setDropBoxOwner(Boolean.parseBoolean(statement.getParameter("DropBoxOwner").getValue()));
        }
        if (statement.existsParameter("Attributes")) {
            result.setAttributes(SetParametersModifier.getValue(statement, "Attributes"));
        }
        if (statement.existsParameter("OldPassword")) {
            result.setOldPassword(statement.getParameter("OldPassword").getValue());
        }
        if (statement.existsParameter("NewPassword")) {
            result.setNewPassword(statement.getParameter("NewPassword").getValue());
        }
        if (statement.existsModifier("RESET PASSWORD")) {
            result.setReset(true);
        }
        if (statement.existsParameter("RemoveAttributes")) {
            StatementSetValue set = statement.getSet("RemoveAttributes");
            result.setRemoveAttributes(IntStream.range(0, set.size()).mapToObj(i -> set.getElement(i).getParameter("Name").getValue()).collect(Collectors.toSet()));
        }
        return result;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        SecurityManager securityManager = this.getSecurityManager(session);
        User user = securityManager.lookupUser(definition.userName);
        if (user != null) {
            if (definition.reset) {
                return new SLResponse("New password: " + securityManager.resetPassword(definition.userName));
            }
            if (definition.oldPassword != null) {
                securityManager.changePassword(definition.userName, definition.oldPassword, definition.newPassword);
                return new SLResponse();
            }
            if (definition.organization != null) {
                securityManager.setUserOrganization(definition.userName, definition.organization);
            }
            boolean needUpdate = false;
            if (definition.alias != null) {
                needUpdate = this.doUpdate(() -> user.setAlias(definition.alias));
            }
            if (definition.description != null) {
                needUpdate = this.doUpdate(() -> user.setDescription(definition.description));
            }
            if (definition.distinguishedEntity != null) {
                needUpdate = this.doUpdate(() -> user.setDistinguishedEntity(definition.distinguishedEntity));
            }
            if (definition.sudoCapable != null) {
                needUpdate = this.doUpdate(() -> user.setSudoCapable(definition.sudoCapable));
            }
            if (definition.dropBoxOwner != null) {
                needUpdate = this.doUpdate(() -> user.setDropBoxOwner(definition.dropBoxOwner));
            }
            if (definition.attributes != null) {
                needUpdate = this.doUpdate(() -> {
                    for (Map.Entry<String, String> entry : definition.attributes.entrySet()) {
                        user.setAttribute(entry.getKey(), entry.getValue());
                    }
                });
            }
            if (definition.removeAttributes != null) {
                needUpdate = this.doUpdate(() -> {
                    for (String attribute : definition.removeAttributes) {
                        user.removeAttribute(attribute);
                    }
                });
            }
            if (needUpdate) {
                this.updateUser((User)session.getOwner(), user);
            }
            if (definition.statement.existsModifier("PROFILE")) {
                this.setProfile(user.getName().toString(), definition.statement, securityManager);
            }
            return new SLResponse();
        }
        return new SLResponse("User not found.", false);
    }

    private void setProfile(String userName, DSLStatement statement, SecurityManager securityManager) throws Exception {
        vCard vcard;
        if (statement.existsModifier("CLEAR")) {
            securityManager.setVCard(userName, null);
        }
        if ((vcard = securityManager.getVCard(userName)) == null) {
            vcard = new vCard();
        }
        if (AlterUserOperation.setProfile(vcard, statement)) {
            securityManager.setVCard(userName, vcard);
        }
    }

    public static class Definition
    extends AbstractSecurityOperation.AbstractAlterCreateUserDefinition {
        private String organization;
        private String alias;
        private String description;
        private Boolean distinguishedEntity;
        private Boolean sudoCapable;
        private Boolean dropBoxOwner;
        private Map<String, String> attributes;
        private Set<String> removeAttributes;
        private String oldPassword;
        private String newPassword;
        private boolean reset;

        public Definition(DSLStatement statement, String syntax) throws ParsingException {
            super(AlterUserOperation.NAME, statement, syntax);
        }

        public String getOrganization() {
            return this.organization;
        }

        public void setOrganization(String organization) {
            this.organization = organization;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isDistinguishedEntity() {
            return this.distinguishedEntity != null && this.distinguishedEntity != false;
        }

        public void setDistinguishedEntity(boolean distinguishedEntity) {
            this.distinguishedEntity = distinguishedEntity;
        }

        public boolean isSudoCapable() {
            return this.sudoCapable != null && this.sudoCapable != false;
        }

        public void setSudoCapable(boolean sudoCapable) {
            this.sudoCapable = sudoCapable;
        }

        public Boolean getDropBoxOwner() {
            return this.dropBoxOwner;
        }

        public void setDropBoxOwner(Boolean dropBoxOwner) {
            this.dropBoxOwner = dropBoxOwner;
        }

        public Map<String, String> getAttributes() {
            return this.attributes != null ? new HashMap<String, String>(this.attributes) : new HashMap();
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public Set<String> getRemoveAttributes() {
            return this.removeAttributes != null ? new HashSet<String>(this.removeAttributes) : new HashSet();
        }

        public void setRemoveAttributes(Set<String> removeAttributes) {
            this.removeAttributes = removeAttributes;
        }

        void setStatement(DSLStatement statement) {
            this.statement = statement;
        }

        public void setReset(boolean reset) {
            this.reset = reset;
        }

        public void setOldPassword(String oldPassword) {
            this.oldPassword = oldPassword;
        }

        public void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }
    }
}

