/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractAlterPasswordOperation;
import com.streamscape.sef.security.User;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.StringParameter;

public class AlterPasswordOperation
extends AbstractAlterPasswordOperation {
    private static final String NAME = "alter password";

    public AlterPasswordOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER PASSWORD").addActionParameter(new ExpressionParameter("UserName"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("OLD").setSyntaxHintSpace()).addParameter(new StringParameter("OldPassword", Character.valueOf('\''), Character.valueOf('\''))));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("NEW").setSyntaxHintSpace()).addParameter(new StringParameter("NewPassword", Character.valueOf('\''), Character.valueOf('\''))));
    }

    @Override
    public String getSyntax(MFSession session) {
        return AlterPasswordOperation.isFromSlangTool(session) ? "alter password [<UserName> old '<OldPassword>' new '<NewPassword>']" : this.syntax.getSyntax();
    }

    @Override
    public String getDescription(MFSession session) {
        return AlterPasswordOperation.isFromSlangTool(session) ? "Changes a password of the session's user." : "Changes a password of the specified user.";
    }

    @Override
    public String getSyntaxDescription(MFSession session) {
        return (AlterPasswordOperation.isFromSlangTool(session) ? "Optional parameters:\n\n" : "Parameters:\n\n") + "   user - Changes a password of the specified user.\n             old - Old password to be checked.\n             new - New password.";
    }

    @Override
    public String getExamples(MFSession session) {
        return (AlterPasswordOperation.isFromSlangTool(session) ? "alter password\n" : "") + "alter password User1 old 'xxx' new 'yyy'";
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("UserName").getValue(), statement.getParameter("OldPassword").getValue(), statement.getParameter("NewPassword").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        this.doInvoke((User)session.getOwner(), definition.userName, definition.oldPassword, definition.newPassword);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String userName;
        private String oldPassword;
        private String newPassword;

        protected Definition() {
            super(AlterPasswordOperation.NAME);
        }

        public Definition(String userName, String oldPassword, String newPassword) {
            super(AlterPasswordOperation.NAME);
            this.userName = userName;
            this.oldPassword = oldPassword;
            this.newPassword = newPassword;
        }

        public String getUserName() {
            return this.userName;
        }
    }
}

