/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractSecurityOperation;
import com.streamscape.sef.security.Organization;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.User;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

public class AlterOrganizationOperation
extends AbstractSecurityOperation {
    private static final String NAME = "alter organization";

    public AlterOrganizationOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER ORGANIZATION").addActionParameter((SyntaxParameter)new IdentifierParameter("Name").setCompletionAdviser(new AbstractSecurityOperation.OrganizationsAdviser(this)));
        this.syntax.addModifier((AbstractModifier)new Modifier("DOMAIN", false).addParameter(new IdentifierParameter("Domain")));
        this.syntax.addModifier((AbstractModifier)new Modifier("DESCRIPTION", false).addParameter(new StringParameter("Description", Character.valueOf('\''), Character.valueOf('\''))));
        this.syntax.setDescription("Sets the specified parameters for the specified organization.");
        this.syntax.setSyntaxDescription("Parameters:\n\n   domain      - Domain of the organization.\n   description - Description of the organization.");
        this.syntax.setExamples("alter organization Org1 domain Domain1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        if (statement.getValuesCount() <= 2) {
            throw new ParsingException(this.getSyntaxErrorMessage("At least one parameter must be specified."));
        }
        return new Definition(statement.getParameter("Name").getValue(), statement.getParameter("Domain").getValue(), statement.getParameter("Description").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        SecurityManager securityManager = this.getSecurityManager(session);
        Organization organization = securityManager.lookupOrganization(definition.organizationName);
        if (organization != null) {
            if (definition.domain != null) {
                securityManager.setOrganizationDomain(definition.organizationName, definition.domain);
            }
            boolean needUpdate = false;
            if (definition.description != null) {
                needUpdate = this.doUpdate(() -> organization.setDescription(definition.description));
            }
            if (needUpdate) {
                this.updateOrganization((User)session.getOwner(), organization);
            }
            return new SLResponse();
        }
        return new SLResponse("Organization not found.", false);
    }

    public static class Definition
    extends AbstractSLStatement {
        private String organizationName;
        private String domain;
        private String description;

        public Definition(String organizationName, String domain, String description) {
            super(AlterOrganizationOperation.NAME);
            this.organizationName = organizationName;
            this.domain = domain;
            this.description = description;
        }

        public String getOrganizationName() {
            return this.organizationName;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

