/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.runtime.mf.operation.security.AbstractGroupOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractSecurityOperation;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.User;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

public class AlterGroupOperation
extends AbstractGroupOperation {
    private static final String NAME = "alter group";

    public AlterGroupOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER GROUP").addActionParameter((SyntaxParameter)new IdentifierParameter("Name").setCompletionAdviser(new AbstractSecurityOperation.GroupsAdviser(this)));
        this.syntax.addModifier((AbstractModifier)new Modifier("ORGANIZATION", false).addParameter((SyntaxParameter)new IdentifierParameter("Organization").setCompletionAdviser(new AbstractSecurityOperation.OrganizationsAdviser(this))));
        this.syntax.addModifier((AbstractModifier)new Modifier("DESCRIPTION", false).addParameter(new StringParameter("Description", Character.valueOf('\''), Character.valueOf('\''))));
        this.syntax.setDescription("Sets the specified parameters for the specified group.");
        this.syntax.setSyntaxDescription("Parameters:\n\n   organization - Organization of the group.\n   description  - Description of the group.");
        this.syntax.setExamples("alter group Group1 organization Org1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        if (statement.getValuesCount() <= 2) {
            throw new ParsingException(this.getSyntaxErrorMessage("At least one parameter must be specified."));
        }
        return new Definition(statement.getParameter("Name").getValue(), statement.getParameter("Organization").getValue(), statement.getParameter("Description").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        SecurityManager securityManager = this.getSecurityManager(session);
        Group group = securityManager.lookupGroup(definition.groupName);
        if (group != null) {
            if (definition.organization != null) {
                securityManager.setGroupOrganization(definition.groupName, definition.organization);
            }
            boolean needUpdate = false;
            if (definition.description != null) {
                needUpdate = this.doUpdate(() -> group.setDescription(definition.description));
            }
            if (needUpdate) {
                this.updateGroup((User)session.getOwner(), group);
            }
            return new SLResponse();
        }
        return new SLResponse("Group not found.", false);
    }

    public static class Definition
    extends AbstractSLStatement {
        private String groupName;
        private String organization;
        private String description;

        public Definition(String groupName, String organization, String description) {
            super(AlterGroupOperation.NAME);
            this.groupName = groupName;
            this.organization = organization;
            this.description = description;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

