/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractSecurityOperation;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.List;
import java.util.stream.Collectors;

abstract class AbstractGrantRevokeOperation
extends AbstractSecurityOperation {
    String commandName;
    String commandPreposition;

    public AbstractGrantRevokeOperation(String name, String preposition) {
        super(true);
        this.commandName = name;
        this.commandPreposition = preposition;
        this.createDSLSyntax(name);
        this.syntax.setAction(name);
        this.syntax.addModifier(this.createPermissionModifier());
        this.syntax.addModifier(((CompoundModifier)new CompoundModifier().setSyntaxHintSpace()).addModifier(new Modifier(preposition)).addParameter(new IdentifierParameter("Grantee")));
        String action = StringUtils.toCapitalized(name) + "s";
        this.syntax.setDescription(action + " the specified access permission " + preposition + " the specified user or group.");
        this.syntax.setSyntaxDescription(name + " <Permission> " + preposition + " <User>  - " + action + " the permission " + preposition + " the user.\n" + name + " <Permission> " + preposition + " <Group> - " + action + " the permission " + preposition + " the group.\n\nPossible permissions:\n" + this.getAllPermissions() + "\n   use on <DataspaceName>");
        this.syntax.setExamples(name + " use on TSPACE.TEST_DATASPACE " + preposition + " User1\n" + name + " administer on services " + preposition + " user User1\n" + name + " all " + preposition + " Group1");
        this.syntax.addCompletionCommand("list users");
        this.syntax.addCompletionCommand("list groups");
        this.syntax.addTag(OperationTag.grant);
    }

    private ChoiceModifier createPermissionModifier() {
        ChoiceModifier result = (ChoiceModifier)((ChoiceModifier)new ChoiceModifier("Permission").setCompactSyntax("<Permission>")).setSyntaxHintSpace();
        result.addModifier(new Modifier(AccessControlOperation.CLIENT_ALLOW_ALL.toSlangName()));
        result.addModifier(new Modifier(AccessControlOperation.SERVICE_ALLOW_ALL.toSlangName()));
        result.addModifier(new Modifier(AccessControlOperation.DATASPACE_ALLOW_ALL.toSlangName()));
        result.addModifier(new Modifier(AccessControlOperation.ALLOW_ALL.toSlangName()));
        for (String value : AccessControlOperation.slangValues()) {
            if (value.startsWith("all")) continue;
            result.addModifier(new Modifier(value));
        }
        result.addModifier((AbstractModifier)new Modifier("USE ON").addParameter(new IdentifierParameter("Dataspace")));
        return result;
    }

    private String getAllPermissions() {
        return ALL_SLANG_PERMISSIONS.stream().map(permission -> "\n   " + permission).collect(Collectors.joining());
    }

    static String getPrefix(String script, String suffix) {
        return script.substring(0, script.indexOf(suffix)) + suffix + " ";
    }

    void fillUsersAndGroups(SecurityManager manager, String prefix, List<String> completions) throws Exception {
        manager.listUsers().forEach(userName -> completions.add(prefix + userName));
        manager.listGroups().forEach(groupName -> completions.add(prefix + groupName));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        GrantOption option = statement.existsModifier("USE ON") ? GrantOption.USEON : GrantOption.REGULAR;
        return this.createDefinition(AccessControlOperation.fromSlangName(statement.getModifier("Permission").getToken()), statement.getParameter("Grantee").getValue(), option, statement.getParameter("Dataspace").getValue());
    }

    abstract Definition createDefinition(AccessControlOperation var1, String var2, GrantOption var3, String var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SLResponse invokeUseOn(Definition statement) throws Exception {
        try (DataspaceAccessor accessor = this.getFabricConnection().createDataspaceAccessor(DataspaceType.valueOf(ModeratorUtils.extractComponentNameType(statement.dataspace).toUpperCase()), ModeratorUtils.extractComponentNameName(statement.dataspace));){
            SLResponse sLResponse = accessor.invokeLanguageRequest(this.commandName + " use " + this.commandPreposition + " " + statement.grantee);
            return sLResponse;
        }
    }

    static enum GrantOption {
        REGULAR,
        USEON;

    }

    public static class Definition
    extends AbstractSLStatement {
        AccessControlOperation permission;
        String grantee;
        GrantOption grantOption;
        String dataspace;

        public Definition(String operationName, AccessControlOperation permission, String grantee, GrantOption grantOption, String dataspace) {
            super(operationName);
            this.permission = permission;
            this.grantee = grantee;
            this.grantOption = grantOption;
            this.dataspace = dataspace;
        }

        public AccessControlOperation getPermission() {
            return this.permission;
        }

        public String getGrantee() {
            return this.grantee;
        }
    }
}

