/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.trigger;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.moderator.AbstractNodeOperation;
import com.streamscape.runtime.mf.operation.scheduler.trigger.AbstractTaskTriggerOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.scheduler.EventTaskTrigger;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.Comparator;

public class ListTaskTriggersOperation
extends AbstractTaskTriggerOperation {
    public static final String NAME = "list task triggers";

    public ListTaskTriggersOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FOR", false).addParameter(new IdentifierParameter("JobName"))).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Returns a list of task triggers in the current node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   for <JobName>  - Returns a list of task triggers for the specified job.\n   at node <Node> - Returns a list of task triggers in the specified node.\n   at domain      - Returns a list of task triggers in all nodes of the sysplex.");
        this.syntax.setExamples("list task triggers\nlist task triggers for job TestJob\nlist task triggers at node TestNode1\nlist task triggers for job TestJob at domain");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement), statement.existsParameter("JobName") ? statement.getParameter("JobName").getValue() : null);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).getNodeName(), statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(ListTaskTriggersOperation.createResultDescriptor());
        ((RuntimeContext)this.callable).getScheduler().getTriggers().stream().sorted(Comparator.comparing(rec$ -> ((EventTaskTrigger)rec$).getName())).filter(trigger -> definition.jobName == null || trigger.getJobName() == null || trigger.getJobName().equals(definition.jobName)).forEach(trigger -> ListTaskTriggersOperation.add(result, new Object[]{node.getName(), trigger.getName(), ListTaskTriggersOperation.convertNull(trigger.getListName()), ListTaskTriggersOperation.convertNull(trigger.getTaskName()), ListTaskTriggersOperation.convertNull(trigger.getJobName()), ListTaskTriggersOperation.convertNull(trigger.getUserName()), trigger.isEnabled()}));
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListTaskTriggersOperation.addColumn(result, "Node");
        ListTaskTriggersOperation.addColumn(result, "Name");
        ListTaskTriggersOperation.addColumn(result, "List");
        ListTaskTriggersOperation.addColumn(result, "Task");
        ListTaskTriggersOperation.addColumn(result, "Job");
        ListTaskTriggersOperation.addColumn(result, "User");
        ListTaskTriggersOperation.addColumn(result, "Enabled");
        return result;
    }

    public static class Definition
    extends AbstractNodeOperation.Definition {
        private String jobName;

        public Definition(String nodeName, String jobName) {
            super(ListTaskTriggersOperation.NAME, nodeName);
            this.jobName = jobName;
        }

        public String getJobName() {
            return this.jobName;
        }
    }
}

