/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.trigger;

import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.scheduler.trigger.AbstractTaskTriggerOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.EventTaskTrigger;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;

public class DescribeTaskTriggerOperation
extends AbstractTaskTriggerOperation {
    public static final String NAME = "describe task trigger";

    public DescribeTaskTriggerOperation() {
        this.createDSLSyntax(NAME);
        this.setAction("DESCRIBE", null);
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("DESCRIPTION"))).addModifier(new Modifier("RPL"))).addModifier(new Modifier("SELECTOR")));
        this.syntax.addModifier(new AtNodeOrAtDomainModifier(false));
        this.syntax.setDescription("Shows information about the specified task trigger in the current node.");
        this.syntax.setDescription("Optional parameters:\n\n   description - Shows the trigger description.\n   rpl         - Shows the RPL script of the trigger.\n   selector    - Shows a selector (when clause) used by the trigger to filter incoming events.");
        this.syntax.setExamples("describe task trigger Test\ndescribe task trigger Test description\ndescribe task trigger Test rpl\ndescribe task trigger Test selector");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(NAME, statement, AtNodeOrAtDomainModifier.getValue(statement));
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, false, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet rowSet = null;
        EventTaskTrigger trigger = this.getTrigger(definition.statement);
        if (definition.statement.existsModifier("DESCRIPTION")) {
            rowSet = new RowSet(DescribeTaskTriggerOperation.createResultDescriptorDescription());
            DescribeTaskTriggerOperation.addValues(rowSet, DescribeTaskTriggerOperation.skipNull(trigger.getDescription()));
        } else if (definition.statement.existsModifier("RPL")) {
            rowSet = new RowSet(DescribeTaskTriggerOperation.createResultDescriptorRpl());
            DescribeTaskTriggerOperation.addValues(rowSet, DescribeTaskTriggerOperation.skipNull(trigger.getScript()));
        } else if (definition.statement.existsModifier("SELECTOR")) {
            rowSet = new RowSet(DescribeTaskTriggerOperation.createResultDescriptor("Selector"));
            DescribeTaskTriggerOperation.addValues(rowSet, DescribeTaskTriggerOperation.skipNull(trigger.getEventSelector()));
        } else {
            rowSet = new RowSet(DescribeTaskTriggerOperation.createSimpleResultDescriptor());
            DescribeTaskTriggerOperation.addValues(rowSet, "Name", trigger.getName());
            DescribeTaskTriggerOperation.addValues(rowSet, "Author", trigger.getAuthor());
            DescribeTaskTriggerOperation.addValues(rowSet, "Created On", DescribeTaskTriggerOperation.formatDate(trigger.getCreationTime()));
            DescribeTaskTriggerOperation.addValues(rowSet, "Last Modified On", DescribeTaskTriggerOperation.formatDate(trigger.getLastUpdateTime()));
            DescribeTaskTriggerOperation.addValues(rowSet, "List", DescribeTaskTriggerOperation.convertNull(trigger.getListName()));
            DescribeTaskTriggerOperation.addValues(rowSet, "Task", DescribeTaskTriggerOperation.convertNull(trigger.getTaskName()));
            DescribeTaskTriggerOperation.addValues(rowSet, "Job", DescribeTaskTriggerOperation.convertNull(trigger.getJobName()));
            DescribeTaskTriggerOperation.addValues(rowSet, "Node", DescribeTaskTriggerOperation.convertNull(trigger.getNodeName()));
            DescribeTaskTriggerOperation.addValues(rowSet, "User", DescribeTaskTriggerOperation.convertNull(trigger.getUserName()));
            DescribeTaskTriggerOperation.addValues(rowSet, new Object[]{"Event Scope", trigger.getEventScope()});
            DescribeTaskTriggerOperation.addValues(rowSet, new Object[]{"Dispatch Mode", trigger.getDispatchMode()});
            DescribeTaskTriggerOperation.addValues(rowSet, "Enabled", trigger.isEnabled());
        }
        return new SLResponse(rowSet);
    }

    protected static class Definition
    extends AbstractSchedulerOperation.Definition {
        String nodeName;

        Definition(String operationName, DSLStatement statement, String nodeName) {
            super(operationName, statement);
            this.nodeName = nodeName;
        }
    }
}

