/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.trigger;

import com.streamscape.runtime.mf.operation.EventScopeModifier;
import com.streamscape.runtime.mf.operation.scheduler.trigger.AbstractTaskTriggerOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.enums.DispatchMode;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.EventTaskTrigger;
import com.streamscape.sef.scheduler.TaskType;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

abstract class AbstractAlterCreateTriggerOperation
extends AbstractTaskTriggerOperation {
    AbstractAlterCreateTriggerOperation(String name) {
        this.createDSLSyntax(name);
        this.setAction();
        this.syntax.addModifier((AbstractModifier)new Modifier("ON", false).addParameter(new AbstractSchedulerOperation.FullTaskNameParameter((AbstractSchedulerOperation)this, TaskType.EVENT, true)));
        this.syntax.addModifier((AbstractModifier)new Modifier("NODE", false).addParameter(new IdentifierParameter("NodeName")));
        this.syntax.addModifier((AbstractModifier)new Modifier("JOB", false).addParameter(new IdentifierParameter("JobName")));
        this.syntax.addModifier((AbstractModifier)new Modifier("USER", false).addParameter(new IdentifierParameter("UserName")));
        this.syntax.addModifier(new EventScopeModifier(EventScope.OBSERVABLE));
        this.syntax.addModifier((AbstractModifier)new Modifier("DISPATCH MODE", false).addParameter(new EnumParameter("DispatchMode").addPossibleValue(DispatchMode.ASYNC.name()).addPossibleValue(DispatchMode.DIRECT.name())));
        this.addScriptModifier();
        this.syntax.addModifier(new Modifier("ENABLE", false));
        this.syntax.setSyntaxDescription("Parameters to specify event sources:\n\n   on <ListName>.<TaskName> - Task that raises events listened by the trigger.\n                              Asterisk can be used instead of <ListName> or <TaskName>:\n                                 <ListName>.* - Any task within the specified task list.\n                                 *.<TaskName> - Task with the specified name within any task list.\n                                 *.*          - Any task list or task (equivalent to a missing parameter).\n   node <NameName>          - Node that holds a corresponding task list.\n   job <JobName>            - Job that executed (scheduled) a corresponding task list.\n   user <UserName>          - User that executed (directly or scheduled) a corresponding task list or task.\n\n\nOptional parameters:\n\n" + this.getLikeDescription() + "   event scope              - Event scope of the trigger (default is OBSERVABLE).\n   dispatch mode            - Dispatch mode of the trigger (default is ASYNC).\n   as                       - RPL script that is performed after receiving a separate event.\n                              The script has a standard Event Trigger syntax.\n                              Received event can be accessed in script with 'this.getCurrentEvent()' function.\n\n   enable                   - Enables the trigger for events listening.");
    }

    protected abstract void setAction();

    protected abstract void addScriptModifier();

    protected String getLikeDescription() {
        return "   like                     - Creates a new trigger based on the existing trigger.\n";
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = new Definition(this.getName(), statement);
        if (statement.existsParameter("TaskListName")) {
            definition.setListName(statement.getParameter("TaskListName").getValue());
        }
        if (statement.existsParameter("TaskName")) {
            definition.setTaskName(statement.getParameter("TaskName").getValue());
        }
        if (statement.existsParameter("NodeName")) {
            definition.setNodeName(statement.getParameter("NodeName").getValue());
        }
        if (statement.existsParameter("JobName")) {
            definition.setJobName(statement.getParameter("JobName").getValue());
        }
        if (statement.existsParameter("UserName")) {
            definition.setUserName(statement.getParameter("UserName").getValue());
        }
        if (EventScopeModifier.hasValue(this.syntax, statement)) {
            definition.setEventScope(EventScopeModifier.getValue(this.syntax, statement));
        }
        if (statement.existsParameter("DispatchMode")) {
            definition.setDispatchMode(DispatchMode.valueOf(statement.getParameter("DispatchMode").getValue()));
        }
        if (statement.existsModifier("ENABLE")) {
            definition.setEnabled(true);
        }
        return definition;
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        EventTaskTrigger trigger = this.getTrigger(definition, session);
        if (definition.listName != null) {
            trigger.setListName(definition.listName);
        }
        if (definition.taskName != null) {
            trigger.setTaskName(definition.taskName);
        }
        if (definition.nodeName != null) {
            trigger.setNodeName(definition.nodeName);
        }
        if (definition.jobName != null) {
            trigger.setJobName(definition.jobName);
        }
        if (definition.userName != null) {
            trigger.setUserName(definition.userName);
        }
        if (definition.eventScope != null) {
            trigger.setEventScope(definition.eventScope);
        }
        if (definition.dispatchMode != null) {
            trigger.setDispatchMode(definition.dispatchMode);
        }
        AbstractAlterCreateTriggerOperation.setScript(trigger, definition.statement);
        if (definition.enabled) {
            trigger.enable();
        }
        return new SLResponse();
    }

    protected abstract EventTaskTrigger getTrigger(Definition var1, MFSession var2) throws Exception;

    protected void setName(EventTaskTrigger trigger, Definition definition) throws Exception {
    }

    protected static class Definition
    extends AbstractSchedulerOperation.Definition {
        private String jobName;
        private String listName;
        private String taskName;
        private String nodeName;
        private String userName;
        private EventScope eventScope;
        private DispatchMode dispatchMode;
        private boolean enabled;

        Definition(String operationName, DSLStatement statement) {
            super(operationName, statement);
        }

        void setListName(String listName) {
            this.listName = this.processAsterisk(listName);
        }

        void setTaskName(String taskName) {
            this.taskName = this.processAsterisk(taskName);
        }

        void setNodeName(String nodeName) {
            this.nodeName = this.processAsterisk(nodeName);
        }

        void setJobName(String jobName) {
            this.jobName = this.processAsterisk(jobName);
        }

        void setUserName(String userName) {
            this.userName = this.processAsterisk(userName);
        }

        private String processAsterisk(String value) {
            return value.equals("*") ? null : value;
        }

        void setEventScope(EventScope eventScope) {
            this.eventScope = eventScope;
        }

        void setDispatchMode(DispatchMode dispatchMode) {
            this.dispatchMode = dispatchMode;
        }

        void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

