/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.template;

import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.SetParametersModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import java.util.Map;

public class SetSchedulerPropertiesOperation
extends AbstractSchedulerOperation {
    public static final String NAME = "set scheduler properties";

    public SetSchedulerPropertiesOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET SCHEDULER PROPERTIES");
        this.syntax.addModifier((AbstractModifier)new SetParametersModifier("", "Properties").setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Sets the specified configuration properties of the Scheduler.");
        this.syntax.setSyntaxDescription("set scheduler properties                     - Sets the specified properties in the current node.\nset scheduler properties at node <NodeName>  - Sets the specified properties in the specified node.\nset scheduler properties at domain           - Sets the specified properties in all nodes of the sysplex.\n\nThe following properties are supported:\n\n   advisory.email.subject - Subject of Scheduler Advisory Email.\n   advisory.email.to      - List of recipients (addresses) of Scheduler Advisory Email.\n                            Addresses must be separated by semicolons.\n\nThe properties must be exactly in the format shown above (they are case-sensitive).");
        this.syntax.setExamples("set scheduler properties (advisory.email.subject = '[@advisoryType] [JOB:@jobName] StreamScape Scheduler Status')\nset scheduler properties (advisory.email.to = 'user1@gmail.com;user2@gmail.com");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement), SetParametersModifier.getValue(statement, "Properties"));
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Scheduler scheduler = this.getScheduler(session);
        for (Map.Entry<String, String> entry : ((Definition)statement).properties.entrySet()) {
            scheduler.setParameter(entry.getKey(), entry.getValue());
        }
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private String nodeName;
        private Map<String, String> properties;

        Definition(String nodeName, Map<String, String> properties) {
            super(SetSchedulerPropertiesOperation.NAME);
            this.nodeName = nodeName;
            this.properties = properties;
        }
    }
}

