/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.template;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.scheduler.template.AbstractTemplateOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.scheduler.NotifyTemplateType;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TemplateType;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.EnumParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ListSchedulerTemplatesOperation
extends AbstractTemplateOperation {
    public static final String NAME = "list scheduler templates";

    public ListSchedulerTemplatesOperation() {
        this.createDSLSyntax(NAME);
        this.addAction("LIST", "TEMPLATES", false, false);
        this.syntax.addModifier((AbstractModifier)new Modifier("TYPE", false).addParameter(new EnumParameter("Type", TemplateType.class)));
        this.syntax.addModifier(new AtNodeOrAtDomainModifier(false));
        this.syntax.setDescription("Shows a list of Scheduler templates in the current node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   type    - Shows a list of Scheduler templates of the specified type.\n   at node - Shows a list of Scheduler templates in the specified node.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement), statement.existsParameter("Type") ? TemplateType.valueOf(statement.getParameter("Type").getValue()) : null);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, false, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet rowSet = new RowSet(ListSchedulerTemplatesOperation.createResultDescriptor("Name", "Type", "Templates"));
        if (definition.type != null) {
            this.addTemplates(definition.type, session, rowSet);
        } else {
            this.addTemplates(TemplateType.NOTIFY, session, rowSet);
            this.addTemplates(TemplateType.TASK, session, rowSet);
            this.addTemplates(TemplateType.TASKLIST, session, rowSet);
        }
        return new SLResponse(rowSet);
    }

    private void addTemplates(TemplateType type, AbstractMFSession session, RowSet rowSet) {
        Scheduler scheduler = this.getScheduler(session);
        TreeMap<String, List<String>> templates = new TreeMap<String, List<String>>();
        for (String string : scheduler.listTemplates(type)) {
            this.addTemplate(string, templates);
        }
        for (Map.Entry entry : templates.entrySet()) {
            ListSchedulerTemplatesOperation.addValues(rowSet, entry.getKey(), type.name(), entry.getValue());
        }
    }

    private void addTemplate(String fullName, Map<String, List<String>> templates) {
        List<String> tokens = StringUtils.split(fullName, ".");
        String subtype = tokens.get(0);
        String name = tokens.get(1);
        if (!templates.containsKey(name)) {
            templates.put(name, new ArrayList());
        }
        List<String> subtypes = templates.get(name);
        if (subtype.equals(NotifyTemplateType.TO.name())) {
            subtypes.add(NotifyTemplateType.TO.name());
        } else if (subtype.equals(NotifyTemplateType.SUBJECT.name())) {
            subtypes.add(NotifyTemplateType.SUBJECT.name());
        } else if (subtype.equals(NotifyTemplateType.BODY.name())) {
            subtypes.add(NotifyTemplateType.BODY.name());
        }
    }

    private static class Definition
    extends AbstractSLStatement {
        String nodeName;
        TemplateType type;

        Definition(String nodeName, TemplateType type) {
            super(ListSchedulerTemplatesOperation.NAME);
            this.nodeName = nodeName;
            this.type = type;
        }
    }
}

