/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.template;

import com.streamscape.runtime.mf.operation.scheduler.template.AbstractTemplateOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.slex.MFSession;

public class DropSchedulerTemplateOperation
extends AbstractTemplateOperation {
    public static final String NAME = "drop scheduler template";

    public DropSchedulerTemplateOperation() {
        this.createDSLSyntax(NAME);
        this.addAction("DROP", "TEMPLATE", true, true);
        this.syntax.addModifier(this.createParametersModifier());
        this.syntax.setDescription("Drops the specified Scheduler Template.");
        this.syntax.setSyntaxDescription("The parameters in parentheses represent the type and subtype of the template.");
        this.syntax.setExamples("drop scheduler template Test (notify, to)\ndrop scheduler template Test (notify, subject)");
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractTemplateOperation.Definition definition = (AbstractTemplateOperation.Definition)statement;
        DropSchedulerTemplateOperation.checkNotifyTemplateType(definition);
        Scheduler scheduler = this.getScheduler(session);
        String templateName = DropSchedulerTemplateOperation.makeTemplateName(definition.subtype, definition.name);
        if (!scheduler.existsTemplate(definition.type, templateName)) {
            throw new Exception("Template not found.");
        }
        this.getScheduler(session).removeTemplate(definition.type, templateName);
        return new SLResponse();
    }
}

