/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.template;

import com.streamscape.runtime.mf.operation.scheduler.template.AbstractTemplateOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.slex.MFSession;

public class DescribeSchedulerTemplateOperation
extends AbstractTemplateOperation {
    public static final String NAME = "describe scheduler template";

    public DescribeSchedulerTemplateOperation() {
        this.createDSLSyntax(NAME);
        this.addAction("DESCRIBE", "TEMPLATE", true, true);
        this.syntax.addModifier(this.createParametersModifier());
        this.syntax.setDescription("Shows information about the specified Scheduler Template.");
        this.syntax.setSyntaxDescription("The parameters in parentheses represent the type and subtype of the template.");
        this.syntax.setExamples("describe scheduler template Test (notify, to)\ndescribe scheduler template Test (notify, subject)");
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractTemplateOperation.Definition definition = (AbstractTemplateOperation.Definition)statement;
        DescribeSchedulerTemplateOperation.checkNotifyTemplateType(definition);
        Scheduler scheduler = this.getScheduler(session);
        String templateName = DescribeSchedulerTemplateOperation.makeTemplateName(definition.subtype, definition.name);
        if (!scheduler.existsTemplate(definition.type, templateName)) {
            throw new Exception("Template not found.");
        }
        RowSet rowSet = new RowSet(DescribeSchedulerTemplateOperation.createResultDescriptor("Template"));
        DescribeSchedulerTemplateOperation.addValues(rowSet, scheduler.getTemplate(definition.type, templateName));
        return new SLResponse(rowSet);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeSchedulerTemplateOperation.addColumn(result, "Template");
        return result;
    }
}

