/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.template;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.NotifyTemplateType;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TemplateType;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.Predicate;
import com.streamscape.slex.lang.modifier.SetModifier;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.value.StatementSetValue;
import java.util.List;
import java.util.stream.Collectors;

abstract class AbstractTemplateOperation
extends AbstractSchedulerOperation {
    AbstractTemplateOperation() {
        super(true);
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.template);
    }

    void addAction(String action, String subject, boolean withName, boolean withAdviser) {
        Modifier template = (Modifier)((Modifier)new Modifier(subject).setIncludeToDefinition(true)).setSyntaxHintSpace();
        if (withName) {
            IdentifierParameter name = new IdentifierParameter("Name");
            if (withAdviser) {
                name.setCompletionAdviser(new TemplateNameCompletionAdviser());
            }
            template.addParameter(name);
        }
        this.syntax.setAction(action).setPredicate(new Predicate("SCHEDULER", false)).addModifier(template);
    }

    SetModifier createParametersModifier() {
        return new SetModifier("Parameters").addModifier((AbstractModifier)new Modifier().addParameter(new EnumParameter("Type", TemplateType.class))).addModifier((AbstractModifier)new Modifier().addParameter(new EnumParameter("Subtype", NotifyTemplateType.class).addPossibleValue("NULL")));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        StatementSetValue parameters = statement.getSet("Parameters");
        return this.createDefinition(statement.getParameter("Name").getValue(), TemplateType.valueOf(parameters.getElement(0).getParameter("Type").getValue().toUpperCase()), parameters.getElement(1).getParameter("Subtype").getValue().toUpperCase());
    }

    protected Definition createDefinition(String name, TemplateType type, String subtype) {
        return new Definition(this.getName(), name, type, subtype);
    }

    static void checkNotifyTemplateType(Definition definition) throws Exception {
        if (definition.type == TemplateType.NOTIFY) {
            try {
                NotifyTemplateType notifyTemplateType = NotifyTemplateType.valueOf(definition.subtype);
            }
            catch (IllegalArgumentException exception) {
                throw new Exception("Invalid subtype '" + definition.subtype + "' for Notify type.");
            }
        } else {
            throw new Exception("Type " + String.valueOf((Object)definition.type) + " is not supported yet.");
        }
    }

    static String makeTemplateName(String subtype, String name) {
        return ModeratorUtils.makeComponentFullName(subtype, name);
    }

    protected class TemplateNameCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser<RuntimeContext> {
        protected TemplateNameCompletionAdviser() {
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            Scheduler scheduler = AbstractTemplateOperation.this.getScheduler(session);
            List<String> templates = scheduler.listTemplates(TemplateType.NOTIFY);
            return templates.stream().map(ModeratorUtils::extractComponentNameName).collect(Collectors.toList());
        }
    }

    protected static class Definition
    extends AbstractSLStatement {
        String name;
        TemplateType type;
        String subtype;

        Definition(String operationName, String name, TemplateType type, String subtype) {
            super(operationName);
            this.name = name;
            this.type = type;
            this.subtype = subtype;
        }
    }
}

