/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.template;

import com.streamscape.runtime.mf.operation.scheduler.template.AbstractTemplateOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.TemplateType;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.StringParameter;

abstract class AbstractAlterCreateTemplateOperation
extends AbstractTemplateOperation {
    protected AbstractAlterCreateTemplateOperation(String action, boolean withAdviser) {
        this.createDSLSyntax(action.toLowerCase() + " scheduler template");
        this.addAction(action, "TEMPLATE", true, withAdviser);
        this.syntax.addModifier(this.createParametersModifier().addModifier((AbstractModifier)new Modifier().addParameter(new StringParameter("Template"))));
        this.syntax.setDescription(this.getDescription() + "Templates are used to configure various features in Scheduler (e.g. Notification Email etc).");
        this.syntax.setSyntaxDescription("The parameters in parentheses represent the type, subtype and body of the template.\nThe template name must be unique for the combination of the type and its subtype.\nThe types can be following:\n\n   notify   - Configures Scheduler Notification Email feature.\n              This type has the following subtypes that configure various parts of an email send by the feature:\n                 to      - List of recipients (addresses) of the email. They must be separated by semicolon.\n                 subject - Subject of the email.\n                 body    - Body of the email.\n   task     - Not supported yet. This type has 'null' subtype.\n   tasklist - Not supported yet. This type has 'null' subtype.\n\nTemplate may include the standard macro substitutions (like global variables etc).\nIt may also include special macro substitutions for a particular type.\n\nThe following special macro substitutions are supported for Notify type:\n\n   @fullAdvisory - Scheduler Advisory that causes an email sending (serialized in JSON format).\n   @advisoryType - Type of Scheduler Advisory that causes an email sending.\n   @nodeName     - Name of Node the email is sent from.\n   @jobName      - Name of Job associated with the email.\n   @listName     - Name of Task List associated with the email.\n   @taskName     - Name of Task associated with the email.");
        this.syntax.setExamples(this.getName() + " Test (notify, to, 'user1@gmail.com;user2@gmail.com')\n" + this.getName() + " Test (notify, subject, '[@advisoryType] [JOB:@jobName] StreamScape Scheduler Status')");
    }

    protected abstract String getDescription();

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition result = (Definition)super.convertDslToSl(statement);
        result.body = statement.getSet("Parameters").getElement(2).getParameter("Template").getValue();
        return result;
    }

    @Override
    protected AbstractTemplateOperation.Definition createDefinition(String name, TemplateType type, String subtype) {
        return new Definition(this.getName(), name, type, subtype);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        AbstractAlterCreateTemplateOperation.checkNotifyTemplateType(definition);
        this.doInvoke(definition, session);
        return new SLResponse();
    }

    protected abstract void doInvoke(Definition var1, MFSession var2) throws Exception;

    static class Definition
    extends AbstractTemplateOperation.Definition {
        String body;

        Definition(String operationName, String name, TemplateType type, String subtype) {
            super(operationName, name, type, subtype);
        }
    }
}

