/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractTaskListOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.ExceptionTask;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.Task;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class RemoveTaskOperation
extends AbstractTaskListOperation {
    public static final String NAME = "remove task";

    public RemoveTaskOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("REMOVE TASK").addActionParameter(new AbstractSchedulerOperation.FullTaskNameParameterWithException((AbstractSchedulerOperation)this, TaskListState.DISABLED));
        this.syntax.setDescription("Removes a specified Task from a specified Task List.\nThe Task List must be in a disabled state.\n\nIf a Rule Set is attached to the Task, this Rule Set will be removed.\nIf there is a State Transition between the Task and another Task, this State Transition will be removed.\nIf the Task is specified as an Exec Task in any Rule, this Rule will be removed.\n\nIf the Task name is 'Exception', it removes an Exception Task associated with the whole Task List.\nIf the Task name ends with '.Exception', it removes an Exception Task associated with the Task.");
        this.syntax.setExamples("remove task TestList.Task1\nremove task TestList.Exception\nremove task TestList.Task1.Exception");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new AbstractSchedulerOperation.Definition(NAME, statement);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        TaskList taskList = RemoveTaskOperation.lookupTaskList(scheduler, definition);
        Task task = this.lookupTask(taskList, definition);
        if (task instanceof ExceptionTask) {
            if (((ExceptionTask)task).isForTaskList()) {
                taskList.removeExceptionTask();
            } else {
                taskList.removeExceptionTask(task.getName());
            }
        } else {
            taskList.removeTask(task.getName());
        }
        scheduler.updateTaskList(taskList);
        return new SLResponse();
    }
}

