/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractRuleSetOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.MFSession;

public class RemoveRuleSetOperation
extends AbstractRuleSetOperation {
    public static final String NAME = "remove ruleset";

    public RemoveRuleSetOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("REMOVE RULESET").addActionParameter(new AbstractRuleSetOperation.FullRuleSetNameParameter((AbstractRuleSetOperation)this, TaskListState.DISABLED));
        this.syntax.setDescription("Removes a specified Rule Set from a specified Task List.\nThe Task List must be in a disabled state.");
        this.syntax.setExamples("remove ruleset TestList.RuleSet1");
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        TaskList taskList = RemoveRuleSetOperation.lookupTaskList(scheduler, definition);
        taskList.removeRuleSet(RemoveRuleSetOperation.getRuleSetName(definition));
        scheduler.updateTaskList(taskList);
        return new SLResponse();
    }
}

