/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractTaskListOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.DateParameter;

public class PurgeTaskListHistoryOperation
extends AbstractTaskListOperation {
    public static final String NAME = "purge tasklist history";

    public PurgeTaskListHistoryOperation() {
        this.createDSLSyntax(NAME);
        this.setAction("PURGE", null);
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("HISTORY").setIncludeToDefinition(true)).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new Modifier("FROM", false).addParameter(new DateParameter("FromTime", SCHEDULER_DATE_FORMAT)));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TO", false).addParameter(new DateParameter("ToTime", SCHEDULER_DATE_FORMAT))).setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Removes all stored historical records of a specified Task List in the current node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   from      - Removes historical records for executions started before this time (including the boundary).\n   to        - Removes historical records for executions started after this time (including the boundary).\n   at node   - Removes all historical records of the Task List in the specified node.\n   at domain - Removes all historical records of the Task List in all nodes of the sysplex.\n\n" + PurgeTaskListHistoryOperation.getTimeFormat());
        this.syntax.setExamples("purge tasklist TestList history\npurge tasklist TestList history from '05-31-2013 08:31:12 PM'\npurge tasklist TestList history to '05-31-2013 08:31:13 PM'\npurge tasklist TestList history from '05-31-2013 08:31:12 PM' to '05-31-2013 08:31:13 PM'\npurge tasklist TestList history at node Node1\npurge tasklist TestList history at domain");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        this.getScheduler(session).purgeExecutions(PurgeTaskListHistoryOperation.getTaskListName(definition.statement), definition.fromTime, definition.toTime);
        return new SLResponse();
    }

    static class Definition
    extends AbstractSchedulerOperation.AbstractPurgeDefinition {
        Definition(DSLStatement statement) throws ParsingException {
            super(PurgeTaskListHistoryOperation.NAME, statement);
        }
    }
}

