/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ListTaskListsOperation
extends AbstractSchedulerOperation {
    public static final String NAME = "list tasklists";

    public ListTaskListsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST TASKLISTS").setAlias("LIST TSKLS");
        this.syntax.addModifier((AbstractModifier)ListTaskListsOperation.createLikeModifier().setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Returns a list of Task Lists in the current node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   like      - Returns a list of Task Lists whose name matches the specified pattern.\n" + ListTaskListsOperation.getLikeModifierDescription("               ", "\n") + "   at node   - Returns a list of Task Lists in the specified node.\n   at domain - Returns a list of Task Lists in the sysplex.");
        this.syntax.setExamples("list tasklists\nlist tasklists like 'Te.*'\nlist tasklists like 'Te%'\nlist tasklists at node Node1\nlist tasklists at domain");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement), ListTaskListsOperation.getLikeParameterValue(statement));
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        AbstractDSLOperation.OperationResult result = new AbstractDSLOperation.OperationResult(ListTaskListsOperation.createResultDescriptor());
        for (TaskList taskList : this.getTaskLists(definition, session)) {
            result.add(new Object[]{((RuntimeContext)this.callable).getName(), taskList.getName(), taskList.getOwner(), taskList.getTasks().size(), ListTaskListsOperation.formatInterval(taskList.getTaskListWindow(), taskList.getTaskListWindowUnit()), ListTaskListsOperation.formatNonNegativeInterval(taskList.getTaskDelay(), TimeUnit.SECONDS), ListTaskListsOperation.formatNonNegativeInterval(taskList.getRetentionInterval(), taskList.getRetentionIntervalUnit()), ListTaskListsOperation.skipNull(taskList.getMetasetName()), taskList.existsMetasetInstance(), ListTaskListsOperation.skipNull(taskList.getJobName()), taskList.isScheduled(), taskList.isAutoComplete(), taskList.isUnordered(), taskList.isTransacted(), taskList.getState(), taskList.isModel(), ListTaskListsOperation.skipNull(taskList.getBaseModel())});
        }
        return result.getResponse();
    }

    private List<TaskList> getTaskLists(Definition definition, MFSession session) throws Exception {
        List<TaskList> result = this.getScheduler(session).getTaskLists();
        if (definition.pattern != null) {
            Pattern pattern = ListTaskListsOperation.compileExtendedPattern(definition.pattern);
            result = result.stream().filter(tl -> pattern.matcher(tl.getName()).matches()).collect(Collectors.toList());
        }
        result.sort(Comparator.comparing(tl -> tl.getName()));
        return result;
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListTaskListsOperation.addColumn(result, "Node");
        ListTaskListsOperation.addColumn(result, "Name");
        ListTaskListsOperation.addColumn(result, "Owner");
        ListTaskListsOperation.addColumn(result, "Tasks Count");
        ListTaskListsOperation.addColumn(result, "Time Window");
        ListTaskListsOperation.addColumn(result, "Task Delay");
        ListTaskListsOperation.addColumn(result, "Retention Interval");
        ListTaskListsOperation.addColumn(result, "Metaset");
        ListTaskListsOperation.addColumn(result, "Metaset Instance");
        ListTaskListsOperation.addColumn(result, "Job");
        ListTaskListsOperation.addColumn(result, "Scheduled");
        ListTaskListsOperation.addColumn(result, "Auto Complete");
        ListTaskListsOperation.addColumn(result, "Unordered");
        ListTaskListsOperation.addColumn(result, "Transacted");
        ListTaskListsOperation.addColumn(result, "State");
        ListTaskListsOperation.addColumn(result, "Is Model");
        ListTaskListsOperation.addColumn(result, "Model Name");
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        private String nodeName;
        private String pattern;

        Definition(String nodeName, String pattern) {
            super(ListTaskListsOperation.NAME);
            this.nodeName = nodeName;
            this.pattern = pattern;
        }
    }
}

