/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractTaskListOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.DataspaceVariableReferenceParameter;
import java.util.List;

public class ExplainTaskListOperation
extends AbstractTaskListOperation {
    public static final String NAME = "explain tasklist";

    public ExplainTaskListOperation() {
        this.createDSLSyntax(NAME);
        this.setAction("EXPLAIN", null);
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("METASET", false).addParameter(new DataspaceVariableReferenceParameter("Metaset"))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new Modifier("GRAPH").setSyntaxHintSpace());
        this.syntax.setDescription("Performs pseudo-execution of a specified Task List to show the execution chain (Task sequence).\nThis command does not actually run tasks of Task List, but simply shows a potential sequence of execution steps.");
        this.syntax.setSyntaxDescription("Parameters:\n\n   graph   - Displays the execution chain in a simple graph format.\n\nOptional parameters:\n\n   metaset - Metaset (set of key-value pairs) that is accessible by Task List and its Tasks during execution.");
        this.syntax.setExamples("explain tasklist Test graph\nexplain tasklist Test metaset @m1 graph");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new AbstractSchedulerOperation.Definition(NAME, statement);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        TaskList taskList = ExplainTaskListOperation.lookupTaskList(this.getScheduler(session), definition.statement);
        if (definition.statement.existsModifier("METASET")) {
            List<Pair<String, String>> chain = taskList.testExecution(this.getMetaset(definition, session));
            if (definition.statement.existsModifier("GRAPH")) {
                StringBuilder builder = new StringBuilder();
                this.addExecChain(chain, builder);
                return this.makeResponse(builder);
            }
        } else {
            List<List<Pair<String, String>>> execChains = taskList.getAllExecChains();
            if (definition.statement.existsModifier("GRAPH")) {
                StringBuilder builder = new StringBuilder();
                for (List<Pair<String, String>> chain : execChains) {
                    this.addExecChain(chain, builder);
                    builder.append("\n");
                }
                return this.makeResponse(builder);
            }
        }
        return new SLResponse();
    }

    private void addExecChain(List<Pair<String, String>> chain, StringBuilder builder) {
        boolean firstStep = true;
        for (Pair<String, String> node : chain) {
            if (!firstStep) {
                builder.append(" --> ");
            } else {
                firstStep = false;
            }
            if (!StringUtils.isEmpty((String)node.first)) {
                builder.append("(").append((String)node.first).append(") ");
            }
            builder.append((String)node.second);
        }
    }

    private SLResponse makeResponse(StringBuilder builder) {
        RowSet rowSet = new RowSet(ExplainTaskListOperation.createResultDescriptor("Chains"));
        ExplainTaskListOperation.addValues(rowSet, builder.toString());
        return new SLResponse(rowSet);
    }
}

