/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractExecOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.MFSession;

public class ExecTaskOperation
extends AbstractExecOperation {
    public static final String NAME = "exec task";

    public ExecTaskOperation() {
        super(NAME);
    }

    @Override
    protected void setAction() {
        this.syntax.setAction("EXEC TASK").addActionParameter((AbstractSchedulerOperation)this.new AbstractSchedulerOperation.FullTaskNameParameter(TaskListState.ENABLED));
    }

    @Override
    protected String doGetDescription() {
        return "Executes a specified Task. Tasks must be part of a Task List defined on the node\nwhere the command is run.";
    }

    @Override
    protected String doGetExamples() {
        return "execute task TestList.Task1\nexec task Test metaset @m1\nexec task Test until '02-02-2024 08:34:03 AM'";
    }

    @Override
    protected String getThreadName() {
        return "FSYS:SLANG.ExecTask";
    }

    @Override
    protected String getThreadDescription() {
        return "Directly executes a Task.";
    }

    @Override
    protected SLResponse doInvoke(AbstractSchedulerOperation.Definition definition, MFSession session, long timeout) throws Exception {
        this.getScheduler(session).executeTask(ExecTaskOperation.getTaskListName(definition.statement), ExecTaskOperation.getTaskName(definition.statement), this.getMetaset(definition, session), new AbstractExecOperation.ExecutionListenerImpl(session, false), this.getUntilTime(definition), this.isAutoExpire(definition));
        return new SLResponse();
    }
}

