/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractExecOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.MFSession;

public class ExecTaskListOperation
extends AbstractExecOperation {
    public static final String NAME = "exec tasklist";

    public ExecTaskListOperation() {
        super(NAME);
    }

    @Override
    protected void setAction() {
        this.setAction("EXEC", TaskListState.ENABLED);
    }

    @Override
    protected String doGetDescription() {
        return "Executes a specified Task List defined on the node where the command is run.";
    }

    @Override
    protected String doGetExamples() {
        return "exec tasklist Test\nexec tasklist Test metaset @m1\nexec tasklist Test until '02-02-2024 08:34:03 AM'";
    }

    @Override
    protected String getThreadName() {
        return "FSYS:SLANG.ExecTaskList";
    }

    @Override
    protected String getThreadDescription() {
        return "Directly executes a Task List.";
    }

    @Override
    protected SLResponse doInvoke(AbstractSchedulerOperation.Definition definition, MFSession session, long timeout) throws Exception {
        this.getScheduler(session).executeTaskList(ExecTaskListOperation.getTaskListName(definition.statement), this.getMetaset(definition, session), new AbstractExecOperation.ExecutionListenerImpl(session, true), this.getUntilTime(definition), this.isAutoExpire(definition));
        return new SLResponse();
    }
}

