/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractTaskListOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;

public class DisableTaskListOperation
extends AbstractTaskListOperation {
    public static final String NAME = "disable tasklist";

    public DisableTaskListOperation() {
        this.createDSLSyntax(NAME);
        this.setAction("DISABLE", TaskListState.ENABLED);
        this.syntax.addModifier((AbstractModifier)new Modifier("FORCE", false).setSyntaxHintSpace());
        this.syntax.setDescription("Disables the specified Task List if it's not running.\nDisabled Task List can be modified, but cannot be executed (directly or by Job).");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   force - Disables the Task List even if it's running.\n           This option is intended for extreme situations only and should not be used on a regular basis.");
        this.syntax.setExamples("disable tasklist Test\ndisable tasklist Test force");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new AbstractSchedulerOperation.Definition(NAME, statement);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        this.getScheduler(session).disableTaskList(DisableTaskListOperation.getTaskListName(definition), definition.statement.existsModifier("FORCE"));
        return new SLResponse();
    }
}

