/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractTaskListOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.ActionTask;
import com.streamscape.sef.scheduler.ExceptionTask;
import com.streamscape.sef.scheduler.NotifyLevel;
import com.streamscape.sef.scheduler.RuleSet;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.Task;
import com.streamscape.sef.scheduler.TaskExecution;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class DescribeTaskOperation
extends AbstractTaskListOperation {
    public static final String NAME = "describe task";

    public DescribeTaskOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE TASK").addActionParameter((AbstractSchedulerOperation)this.new AbstractSchedulerOperation.FullTaskNameParameterWithException((TaskListState[])null));
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("EXCEPTION"))).addModifier(new Modifier("DESCRIPTION"))).addModifier(new Modifier("METADATA"))).addModifier(new Modifier("PROPERTIES"))).addModifier(new Modifier("TAGS"))).addModifier(new Modifier("RPL"))).addModifier(new CompoundModifier().addModifier(new Modifier("EXEC")).addModifier((AbstractModifier)new Modifier("ID", false).addParameter(new IdentifierParameter("ExecId"))).addModifier(new Modifier("FACETS", false))));
        this.syntax.addModifier(new AtNodeOrAtDomainModifier(false));
        this.syntax.setDescription("Shows information about a specified Task in the current node.\nIf the Task name is 'Exception', it shows information about an Exception Task associated with the whole Task List.\nIf the Task name ends with '.Exception', it shows information about an Exception Task associated with the Task.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   description - Shows the Task description.\n   metadata    - Shows the Task List metadata.\n   properties  - Shows a list of properties of the Task.\n   tags        - Shows a list of tags of the Task.\n   rpl         - Shows the RPL script of the Task.\n                 This parameter is applicable only to ACTION Task.\n   exec        - Shows the active Execution of the Task.\n      facets   - Shows a list of Completion facets of the active Execution of the Task.\n   exec id     - Shows the specified Execution of the Task.\n      facets   - Shows a list of Completion facets of the specified Execution of the Task.\n   at node     - Shows information about the Task List in the specified node.");
        this.syntax.setExamples("describe task TestList.Task1\ndescribe task TestList.Task1 at node Node1\ndescribe task TestList.Task1 description\ndescribe task TestList.Task1 properties\ndescribe task TestList.Task1 tags\ndescribe task TestList.Task1 rpl\ndescribe task TestList.Task1 exec\ndescribe task TestList.Task1 exec id c3aa9224-6f2d-4212-8e82-fb894f8e10f8\ndescribe task TestList.Task1 exec facets\ndescribe task TestList.Task1 exec id c3aa9224-6f2d-4212-8e82-fb894f8e10f8 facets\ndescribe task TestList.Exception\ndescribe task TestList.Task1.Exception");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(this, statement);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        Task task = this.lookupTask(scheduler, (AbstractSchedulerOperation.Definition)definition);
        RowSet rowSet = null;
        if (definition.description) {
            rowSet = new RowSet(DescribeTaskOperation.createResultDescriptorDescription());
            DescribeTaskOperation.addValues(rowSet, DescribeTaskOperation.skipNull(task.getDescription()));
        } else if (definition.metadata) {
            rowSet = new RowSet(DescribeTaskOperation.createResultDescriptor("Metadata"));
            DescribeTaskOperation.addValues(rowSet, DescribeTaskOperation.skipNull(task.getMetadata()));
        } else if (definition.properties) {
            rowSet = new RowSet(DescribeTaskOperation.createResultDescriptorProperties());
            List<Map.Entry<String, Object>> properties = task.getPropertyList();
            properties.sort(Map.Entry.comparingByKey());
            for (Map.Entry<String, Object> property : properties) {
                DescribeTaskOperation.addValues(rowSet, property.getKey(), property.getValue().toString(), DescribeTaskOperation.skipNull(task.getPropertyResolved(property.getKey())));
            }
        } else if (definition.tags) {
            rowSet = new RowSet(DescribeTaskOperation.createResultDescriptorTags());
            for (String tag : new TreeSet<String>(task.listTags())) {
                DescribeTaskOperation.addValues(rowSet, tag);
            }
        } else if (definition.statement.existsModifier("RPL")) {
            if (!(task instanceof ActionTask)) {
                throw new Exception("Task is not ACTION Task.");
            }
            if (!(!((ActionTask)task).isEncrypted() || task.getOwner().equals(session.getOwnerName()) && session.getOwner().isAdministrator())) {
                throw new Exception("User '" + session.getOwnerName() + "' has insufficient rights for this operation.");
            }
            rowSet = new RowSet(DescribeTaskOperation.createResultDescriptorRpl());
            DescribeTaskOperation.addValues(rowSet, DescribeTaskOperation.skipNull(((ActionTask)task).getScript()));
        } else if (definition.exec != null) {
            rowSet = this.describeExec(scheduler, task, definition);
        } else {
            rowSet = new RowSet(DescribeTaskOperation.createSimpleResultDescriptor());
            if (task instanceof ExceptionTask) {
                rowSet = new RowSet(DescribeTaskOperation.createSimpleResultDescriptor());
                ExceptionTask exceptionTask = (ExceptionTask)task;
                DescribeTaskOperation.addValues(rowSet, "Node", ((RuntimeContext)this.callable).getName());
                DescribeTaskOperation.addValues(rowSet, "Task List", exceptionTask.getTaskList().getName());
                DescribeTaskOperation.addValues(rowSet, "Task Name", exceptionTask.getName());
                DescribeTaskOperation.addValues(rowSet, new Object[]{"Type", exceptionTask.getType()});
                DescribeTaskOperation.addValues(rowSet, "Author", exceptionTask.getAuthor());
                DescribeTaskOperation.addValues(rowSet, "Created On", DescribeTaskOperation.formatDate(exceptionTask.getCreationTime()));
                DescribeTaskOperation.addValues(rowSet, "Last Modified On", DescribeTaskOperation.formatDate(exceptionTask.getLastUpdateTime()));
                DescribeTaskOperation.addValues(rowSet, "Task Window", DescribeTaskOperation.formatTaskWindow(exceptionTask));
                DescribeTaskOperation.addValues(rowSet, new Object[]{"Event Scope", exceptionTask.getTaskList().getEventScope()});
                DescribeTaskOperation.addValues(rowSet, "Events", this.listEvents(exceptionTask));
                DescribeTaskOperation.addValues(rowSet, "Encrypted", exceptionTask.isEncrypted());
                DescribeTaskOperation.addValues(rowSet, new Object[]{"State", exceptionTask.getState()});
            } else {
                RuleSet afterRs = task.getTaskList().getRuleSetByExecTask(task.getOID());
                DescribeTaskOperation.addValues(rowSet, "Node", ((RuntimeContext)this.callable).getName());
                DescribeTaskOperation.addValues(rowSet, "Task List", task.getTaskList().getName());
                DescribeTaskOperation.addValues(rowSet, "Name", task.getName());
                DescribeTaskOperation.addValues(rowSet, new Object[]{"Type", task.getType()});
                DescribeTaskOperation.addValues(rowSet, "Author", task.getAuthor());
                DescribeTaskOperation.addValues(rowSet, "Created On", DescribeTaskOperation.formatDate(task.getCreationTime()));
                DescribeTaskOperation.addValues(rowSet, "Last Modified On", DescribeTaskOperation.formatDate(task.getLastUpdateTime()));
                DescribeTaskOperation.addValues(rowSet, "Task Window", DescribeTaskOperation.formatTaskWindow(task));
                DescribeTaskOperation.addValues(rowSet, "Resume On", DescribeTaskOperation.getResumeOn(task));
                DescribeTaskOperation.addValues(rowSet, "Exception", task.getExceptionTask() != null);
                DescribeTaskOperation.addValues(rowSet, "Weight", DescribeTaskOperation.formatWeight(task));
                DescribeTaskOperation.addValues(rowSet, "After Task", DescribeTaskOperation.skipNull(task.getAfterTaskOID() != null ? task.getAfterTaskName() : (afterRs != null ? afterRs.getTask().getName() : null)));
                DescribeTaskOperation.addValues(rowSet, "Conditional", afterRs != null);
                DescribeTaskOperation.addValues(rowSet, "Rule Set", DescribeTaskOperation.skipNull(task.getRuleSet() != null ? task.getRuleSet().getName() : null));
                DescribeTaskOperation.addValues(rowSet, "Auto Complete", task.getTaskList().isAutoComplete());
                DescribeTaskOperation.addValues(rowSet, new Object[]{"Event Scope", task.getTaskList().getEventScope()});
                DescribeTaskOperation.addValues(rowSet, "Events", this.listEvents(task));
                if (task instanceof ActionTask) {
                    DescribeTaskOperation.addValues(rowSet, "Undo Limit", ((ActionTask)task).getUndoLimit());
                    DescribeTaskOperation.addValues(rowSet, "RPL script", DescribeTaskOperation.formatRplScript(task));
                    DescribeTaskOperation.addValues(rowSet, "Encrypted", ((ActionTask)task).isEncrypted());
                    DescribeTaskOperation.addValues(rowSet, "Model", DescribeTaskOperation.skipNull(((ActionTask)task).getModel()));
                }
                DescribeTaskOperation.addValues(rowSet, new Object[]{"State", task.getState()});
                if (task.getExecution() != null) {
                    DescribeTaskOperation.addValues(rowSet, "Execution ID", task.getExecution().getEID());
                    DescribeTaskOperation.addValues(rowSet, "Execution Started At", DescribeTaskOperation.formatExecTime(this.getStartTime(task)));
                    DescribeTaskOperation.addValues(rowSet, "Execution Until", DescribeTaskOperation.formatExecTime(task.getEndTimeMsec()));
                    DescribeTaskOperation.addValues(rowSet, "Execution User", task.getExecution().getCaller());
                }
            }
        }
        return new SLResponse(rowSet);
    }

    private List<String> listEvents(Task task) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("advisory.Scheduler");
        result.add("exception.Scheduler");
        ScheduledJob job = task.getTaskList().getJob();
        if (job != null && job.isNotify() && job.getNotifyLevel() == NotifyLevel.TASK) {
            result.add("event.Scheduler.Email");
        }
        result.addAll(task.listEventIds());
        return result;
    }

    private RowSet describeExec(Scheduler scheduler, Task task, Definition definition) throws Exception {
        RowSet rowSet;
        TaskExecution execution = task.getExecution();
        if (definition.exec.eid != null) {
            execution = DescribeTaskOperation.getExecution(scheduler, definition).getTaskExecution(task.getName());
        } else if (execution == null) {
            return new RowSet();
        }
        if (definition.exec.facets) {
            rowSet = new RowSet(DescribeTaskOperation.createResultDescriptor("Key", "Type", "Value"));
            for (String key : execution.listFacets().stream().sorted().collect(Collectors.toList())) {
                Object value = execution.getFacet(key);
                AbstractDSLOperation.PropertyValue.Type type = AbstractDSLOperation.PropertyValue.Type.resolveType(value);
                DescribeTaskOperation.addValues(rowSet, key, type != null ? type.toPrintString() : "n/a", value);
            }
        } else {
            rowSet = new RowSet(DescribeTaskOperation.createSimpleResultDescriptor());
            DescribeTaskOperation.addValues(rowSet, "Execution ID", execution.getEID());
            DescribeTaskOperation.addValues(rowSet, "Caller", execution.getCaller());
            DescribeTaskOperation.addValues(rowSet, "Task Name", execution.getTaskName());
            DescribeTaskOperation.addValues(rowSet, "Execution Mode", DescribeTaskOperation.skipNull((Object)execution.getExecutionMode()));
            DescribeTaskOperation.addValues(rowSet, "Weight", DescribeTaskOperation.formatWeight(execution.getWeight(), true));
            DescribeTaskOperation.addValues(rowSet, "Auto Complete", execution.isAutoComplete());
            if (task instanceof ActionTask) {
                DescribeTaskOperation.addValues(rowSet, "Undo Limit", execution.getUndoLimit());
                DescribeTaskOperation.addValues(rowSet, "Undo Count", execution.getUndoCount());
            }
            if (execution.getCompletionState() != null) {
                DescribeTaskOperation.addValues(rowSet, "Completion Start Time", DescribeTaskOperation.formatExecTime(execution.getCompletionStartTime()));
                DescribeTaskOperation.addValues(rowSet, "Completion End Time", DescribeTaskOperation.formatExecTime(execution.getCompletionEndTime()));
                DescribeTaskOperation.addValues(rowSet, new Object[]{"Completion State", execution.getCompletionState()});
            }
            if (execution.getState() != null) {
                DescribeTaskOperation.addValues(rowSet, "Execution Start Time", DescribeTaskOperation.formatExecTime(execution.getStartTime()));
                DescribeTaskOperation.addValues(rowSet, "Execution End Time", DescribeTaskOperation.formatExecTime(execution.getEndTime()));
                DescribeTaskOperation.addValues(rowSet, new Object[]{"Execution State", execution.getState()});
            }
            if (execution.getErrorMessage() != null) {
                DescribeTaskOperation.addValues(rowSet, "Error Message", execution.getErrorMessage());
            }
            if (execution.getErrorCode() != 0) {
                DescribeTaskOperation.addValues(rowSet, "Error Code", execution.getErrorCode());
            }
        }
        return rowSet;
    }

    private Date getStartTime(Task task) {
        return task.isAutoComplete() ? task.getExecution().getStartTime() : task.getExecution().getCompletionStartTime();
    }

    static class Definition
    extends AbstractTaskListOperation.AbstractDescribeDefinition {
        Definition(AbstractSchedulerOperation operation, DSLStatement statement) throws ParsingException {
            super(operation, statement);
        }
    }
}

