/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractTaskListOperation;
import com.streamscape.sdo.AbstractNamedObject;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.scheduler.AbstractExecution;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.ExceptionTask;
import com.streamscape.sef.scheduler.JobState;
import com.streamscape.sef.scheduler.RuleSet;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.Task;
import com.streamscape.sef.scheduler.TaskExecution;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListExecution;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class DescribeTaskListOperation
extends AbstractTaskListOperation {
    public static final String NAME = "describe tasklist";

    public DescribeTaskListOperation() {
        this.createDSLSyntax(NAME);
        this.setAction("DESCRIBE", null);
        CompoundModifier exec = this.createExecModifier(true, true).addModifier(new ChoiceModifier(false).addPossibleValues("METASET", "FACETS")).addModifier((AbstractModifier)new Modifier("ALL", false).setAlias(null));
        ((DSLStatementSyntax)this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("DESCRIPTION"))).addModifier(new Modifier("METADATA"))).addModifier(new Modifier("PROPERTIES"))).addModifier(new Modifier("TAGS"))).addModifier(new Modifier("TASKS"))).addModifier(new Modifier("EXCEPTIONS"))).addModifier(new Modifier("RULESETS"))).addModifier(exec))).setCompactSyntax("[{ description | metadata | properties | tags | tasks | rulesets |\n   exec [{ id <ExecId> [{ metaset | facets }] |\n           last [{ <N> | * [count] [[from '<FromTime>'] [to '<ToTime>']] }] [where (<Condition>)] [{ asc | desc }]\n          [all] }]");
        this.syntax.addModifier(new AtNodeOrAtDomainModifier(false));
        this.syntax.setDescription("Shows information about the specified Task List in the current node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   description   - Shows the Task List description.\n   metadata      - Shows the Task List metadata.\n   properties    - Shows a list of properties of the Task List.\n   tags          - Shows a list of tags of the Task List.\n   tasks         - Shows a list of all Tasks in the Task List.\n   exceptions    - Shows a list of all Exceptions in the Task List.\n   rulesets      - Shows a list of all Rule Sets in the Task List.\n   exec          - Shows the active Execution of the Task List.\n      metaset    - Shows a metaset of the active Execution of the Task List.\n      facets     - Shows a list of Completion facets of the active Execution of the Task List.\n   exec id       - Shows the specified Execution of the Task List.\n      metaset    - Shows a metaset of the specified Execution of the Task List.\n      facets     - Shows a list of Completion facets of the specified Execution of the Task List.\n   exec last     - Shows the last Execution of the Task List.\n   exec last &lt;N&gt; - Shows the specified count of last Executions of the Task List.\n      where      - See description below.\n      asc | <u>desc</u> - Specifies if the result is sorted in ascending or descending order.\n   exec last *   - Shows a list of all Executions of the Task List.\n      count      - Shows the number of Executions.\n      from       - Shows a list of Executions started at or after the specified time.\n      to         - Shows a list of Executions started at or before the specified time.\n      where      - Filters the result Executions by the specified condition, which is applied to each Task in the result.\n                   This condition uses the Event Selector syntax and takes the Completion Facets as a source of its variables.\n                   So, this option filters the Executions whose Tasks have the Completion Facets that match the specified condition.\n      <u>asc</u> | desc - Specifies if the result is sorted in ascending or descending order.\n   all           - Shows the result Executions in a detailed format.\n   at node       - Shows information about the Task List in the specified node.\n\nTime format is '" + SCHEDULER_DATE_FORMAT.toPattern() + "' (e.g. 05-31-2013 08:31:12 PM).");
        this.syntax.setExamples("describe tasklist Test\ndescribe tasklist Test at node Node1\ndescribe tasklist Test tasks\ndescribe tasklist Test tasks at node TestNode1\ndescribe tasklist Test rulesets\ndescribe tasklist Test description\ndescribe tasklist Test properties\ndescribe tasklist Test tags\ndescribe tasklist Test exec\ndescribe tasklist Test exec all\ndescribe tasklist Test exec metaset\ndescribe tasklist Test exec facets\ndescribe tasklist Test exec id c3aa9224-6f2d-4212-8e82-fb894f8e10f8\ndescribe tasklist Test exec id c3aa9224-6f2d-4212-8e82-fb894f8e10f8 all\ndescribe tasklist Test exec id c3aa9224-6f2d-4212-8e82-fb894f8e10f8 metaset\ndescribe tasklist Test exec id c3aa9224-6f2d-4212-8e82-fb894f8e10f8 facets\ndescribe tasklist Test exec last\ndescribe tasklist Test exec last 5\ndescribe tasklist Test exec last 5 asc\ndescribe tasklist Test exec last 5 where (id=12345)\ndescribe tasklist Test exec last *\ndescribe tasklist Test exec last * where (id=12345 and key='xyz')\ndescribe tasklist Test exec last * asc\ndescribe tasklist Test exec last all\ndescribe tasklist Test exec last 5 all\ndescribe tasklist Test exec last * all\ndescribe tasklist Test exec last * where (id=12345) all\ndescribe tasklist Test exec last * all asc\ndescribe tasklist Test exec last * count\ndescribe tasklist Test exec last * from '05-31-2019 08:31:12 PM'\ndescribe tasklist Test exec last * to '06-31-2019 08:31:12 PM'\ndescribe tasklist Test exec last * from '05-31-2019 08:31:12 PM' to '06-31-2019 08:31:12 PM'\ndescribe tasklist Test exec last * from '05-31-2019 08:31:12 PM' to '06-31-2019 08:31:12 PM' where (id=12345)\ndescribe tasklist Test exec last * from '05-31-2019 08:31:12 PM' all\ndescribe tasklist Test exec last * to '06-31-2019 08:31:12 PM' all\ndescribe tasklist Test exec last * count from '05-31-2019 08:31:12 PM' to '06-31-2019 08:31:12 PM'\ndescribe tasklist Test exceptions\ndescribe tasklist Test exceptions at node TestNode1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return DescribeTaskListOperation.getDefinition(this, statement);
    }

    private static Definition getDefinition(DescribeTaskListOperation operation, DSLStatement statement) throws ParsingException {
        Definition definition = new Definition(operation, statement);
        if (definition.exec != null) {
            if (definition.exec.last) {
                if (definition.exec.metaset) {
                    throw new ParsingException(DescribeTaskListOperation.getSyntaxErrorMessage(operation, "Parameters 'metaset' and 'exec last' cannot be specified together."));
                }
                if (definition.exec.facets) {
                    throw new ParsingException(DescribeTaskListOperation.getSyntaxErrorMessage(operation, "Parameters 'facets' and 'exec last' cannot be specified together."));
                }
            }
            if (definition.exec.count) {
                if (definition.exec.orderByAsc != null) {
                    throw new ParsingException(DescribeTaskListOperation.getSyntaxErrorMessage(operation, "Parameters 'count' and '" + (definition.exec.orderByAsc != false ? "asc" : "desc") + "' cannot be specified together."));
                }
                if (definition.exec.all) {
                    throw new ParsingException(DescribeTaskListOperation.getSyntaxErrorMessage(operation, "Parameters 'count' and 'all' cannot be specified together."));
                }
            }
        }
        return definition;
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        TaskList taskList = DescribeTaskListOperation.lookupTaskList(scheduler, definition);
        RowSet rowSet = null;
        if (definition.description) {
            rowSet = new RowSet(DescribeTaskListOperation.createResultDescriptorDescription());
            DescribeTaskListOperation.addValues(rowSet, DescribeTaskListOperation.skipNull(taskList.getDescription()));
        } else if (definition.metadata) {
            rowSet = new RowSet(DescribeTaskListOperation.createResultDescriptor("Metadata"));
            DescribeTaskListOperation.addValues(rowSet, DescribeTaskListOperation.skipNull(taskList.getMetadata()));
        } else if (definition.properties) {
            rowSet = new RowSet(DescribeTaskListOperation.createResultDescriptorProperties());
            List<Map.Entry<String, Object>> properties = taskList.getPropertyList();
            properties.sort(Map.Entry.comparingByKey());
            for (Map.Entry<String, Object> property : properties) {
                DescribeTaskListOperation.addValues(rowSet, property.getKey(), property.getValue().toString(), DescribeTaskListOperation.skipNull(taskList.getPropertyResolved(property.getKey())));
            }
        } else if (definition.tags) {
            rowSet = new RowSet(DescribeTaskListOperation.createResultDescriptorTags());
            for (String tag : new TreeSet<String>(taskList.listTags())) {
                DescribeTaskListOperation.addValues(rowSet, tag);
            }
        } else if (definition.statement.existsModifier("TASKS")) {
            rowSet = new RowSet(DescribeTaskListOperation.createResultDescriptorTasks());
            for (Task task : taskList.getTasks()) {
                RuleSet afterRs = task.getTaskList().getRuleSetByExecTask(task.getOID());
                DescribeTaskListOperation.addValues(rowSet, new Object[]{task.getName(), task.getType().name(), DescribeTaskListOperation.skipNull(task.getAfterTaskOID() != null ? task.getAfterTaskName() : (afterRs != null ? afterRs.getTask().getName() : null)), afterRs != null, DescribeTaskListOperation.skipNull(task.getRuleSet() != null ? task.getRuleSet().getName() : null), DescribeTaskListOperation.formatTaskWindow(task), DescribeTaskListOperation.getResumeOn(task), task.getExceptionTask() != null, DescribeTaskListOperation.formatWeight(task), task.isAutoComplete(), DescribeTaskListOperation.formatRplScript(task), task.getState()});
            }
        } else if (definition.statement.existsModifier("EXCEPTIONS")) {
            rowSet = new RowSet(DescribeTaskListOperation.createResultDescriptorExceptions());
            if (taskList.existsExceptionTask()) {
                DescribeTaskListOperation.addExceptionTask(rowSet, taskList.getExceptionTask());
            }
            for (ExceptionTask task : taskList.getExceptionTasks()) {
                DescribeTaskListOperation.addExceptionTask(rowSet, task);
            }
        } else if (definition.statement.existsModifier("RULESETS")) {
            rowSet = new RowSet(DescribeTaskListOperation.createResultDescriptorRuleSets());
            List<RuleSet> ruleSets = taskList.getRuleSets();
            ruleSets.sort(Comparator.comparing(AbstractNamedObject::getName));
            for (RuleSet ruleSet : ruleSets) {
                DescribeTaskListOperation.addValues(rowSet, ruleSet.getName(), ruleSet.getTask().getName(), ruleSet.listRules());
            }
        } else {
            rowSet = definition.exec != null ? DescribeTaskListOperation.describeExec(scheduler, definition) : this.describeGeneral(taskList, definition);
        }
        return new SLResponse(rowSet);
    }

    private RowSet describeGeneral(TaskList taskList, Definition definition) {
        RowSet rowSet = new RowSet(DescribeTaskListOperation.createSimpleResultDescriptor());
        DescribeTaskListOperation.addValues(rowSet, "Node", ((RuntimeContext)this.callable).getName());
        DescribeTaskListOperation.addValues(rowSet, "Name", taskList.getName());
        DescribeTaskListOperation.addValues(rowSet, "Author", taskList.getAuthor());
        DescribeTaskListOperation.addValues(rowSet, "Created On", DescribeTaskListOperation.formatDate(taskList.getCreationTime()));
        DescribeTaskListOperation.addValues(rowSet, "Owner", taskList.getOwner());
        DescribeTaskListOperation.addValues(rowSet, "Last Modified On", DescribeTaskListOperation.formatDate(taskList.getLastUpdateTime()));
        DescribeTaskListOperation.addValues(rowSet, "Time Window", DescribeTaskListOperation.formatInterval(taskList.getTaskListWindow(), taskList.getTaskListWindowUnit()));
        DescribeTaskListOperation.addValues(rowSet, "Task Delay", DescribeTaskListOperation.formatNonNegativeInterval(taskList.getTaskDelay(), TimeUnit.SECONDS));
        DescribeTaskListOperation.addValues(rowSet, "Retention Interval", DescribeTaskListOperation.formatNonNegativeInterval(taskList.getRetentionInterval(), taskList.getRetentionIntervalUnit()));
        DescribeTaskListOperation.addValues(rowSet, "Metaset", DescribeTaskListOperation.skipNull(taskList.getMetasetName()));
        DescribeTaskListOperation.addValues(rowSet, "Metaset Instance", taskList.existsMetasetInstance());
        DescribeTaskListOperation.addValues(rowSet, "Auto Complete", taskList.isAutoComplete());
        DescribeTaskListOperation.addValues(rowSet, "Unordered", taskList.isUnordered());
        DescribeTaskListOperation.addValues(rowSet, "Transacted", taskList.isTransacted());
        DescribeTaskListOperation.addValues(rowSet, new Object[]{"Event Scope", taskList.getEventScope()});
        DescribeTaskListOperation.addValues(rowSet, "Has Exception", taskList.getExceptionTask() != null);
        DescribeTaskListOperation.addValues(rowSet, "Model", taskList.isModel());
        if (taskList.isCreatedFromModel()) {
            DescribeTaskListOperation.addValues(rowSet, "Created From Model", taskList.getBaseModel());
        } else if (taskList.isImportedFromModel()) {
            DescribeTaskListOperation.addValues(rowSet, "Imported From Model", taskList.getBaseModel());
        }
        ScheduledJob job = taskList.getJob();
        if (job != null) {
            DescribeTaskListOperation.addValues(rowSet, "Job", job.getName());
            DescribeTaskListOperation.addValues(rowSet, "Scheduled", taskList.isScheduled());
            DescribeTaskListOperation.addValues(rowSet, "Notification Enabled", job.isNotify());
            DescribeTaskListOperation.addValues(rowSet, new Object[]{"Notification Level", job.getNotifyLevel()});
        }
        DescribeTaskListOperation.addValues(rowSet, "Events", this.listEvents(taskList));
        DescribeTaskListOperation.addValues(rowSet, new Object[]{"State", taskList.getState()});
        TaskListExecution execution = taskList.getExecution();
        if (execution != null) {
            DescribeTaskListOperation.addValues(rowSet, "Execution ID", execution.getEID());
            DescribeTaskListOperation.addValues(rowSet, "Execution Started At", DescribeTaskListOperation.formatExecTime(execution.getStartTime()));
            DescribeTaskListOperation.addValues(rowSet, "Execution Until", DescribeTaskListOperation.formatExecTime(taskList.getEndTimeMsec()));
            DescribeTaskListOperation.addValues(rowSet, "Execution User", execution.getCaller());
            DescribeTaskListOperation.addValues(rowSet, "Execution Progress", DescribeTaskListOperation.formatWeight(execution.getTotalProgress(), true));
        } else if (job != null && job.getState() != JobState.DISABLED && job.getNextExecutionTime() != null) {
            DescribeTaskListOperation.addValues(rowSet, "Next Execution Time", DescribeTaskListOperation.formatExecTime(job.getNextExecutionTime()));
        }
        return rowSet;
    }

    public static RowSet describeExec(DescribeTaskListOperation operation, String command, Scheduler scheduler) throws Exception {
        DSLStatement statement = operation.parseDsl(command);
        Definition definition = DescribeTaskListOperation.getDefinition(operation, statement);
        return DescribeTaskListOperation.describeExec(scheduler, definition);
    }

    private static RowSet describeExec(Scheduler scheduler, Definition definition) throws Exception {
        RowSet rowSet;
        block8: {
            List<TaskListExecution> executions;
            block9: {
                TaskListExecution execution;
                block10: {
                    block7: {
                        if (!definition.exec.count) break block7;
                        rowSet = new RowSet(DescribeTaskListOperation.createResultDescriptor("Count"));
                        DescribeTaskListOperation.addValues(rowSet, DescribeTaskListOperation.getExecutionsNumber(scheduler, definition));
                        break block8;
                    }
                    executions = DescribeTaskListOperation.getExecutions(scheduler, definition);
                    if (!definition.exec.metaset && !definition.exec.facets) break block9;
                    if (executions.isEmpty()) {
                        throw new Exception("Execution not found.");
                    }
                    execution = executions.get(0);
                    if (!definition.exec.metaset) break block10;
                    rowSet = new RowSet(DescribeTaskListOperation.createSimpleResultDescriptor());
                    if (execution.getMetasetName() == null) break block8;
                    DescribeTaskListOperation.addValues(rowSet, "Metaset Name", execution.getMetasetName());
                    DescribeTaskListOperation.addValues(rowSet, "Before Values", execution.getBeforeMetasetValues());
                    if (execution.getAfterMetasetValues() == null) break block8;
                    DescribeTaskListOperation.addValues(rowSet, "After Values", execution.getAfterMetasetValues());
                    break block8;
                }
                rowSet = new RowSet(DescribeTaskListOperation.createResultDescriptor("Key", "Type", "Value"));
                for (String key : execution.listFacets().stream().sorted().collect(Collectors.toList())) {
                    Object value = execution.getFacet(key);
                    AbstractDSLOperation.PropertyValue.Type type = AbstractDSLOperation.PropertyValue.Type.resolveType(value);
                    DescribeTaskListOperation.addValues(rowSet, key, type != null ? type.toPrintString() : "n/a", value);
                }
                break block8;
            }
            if (definition.exec.all) {
                rowSet = new RowSet(DescribeTaskListOperation.createResultDescriptorExecAll());
                for (TaskListExecution execution : executions) {
                    for (TaskExecution taskExec : execution.getTaskExecutions()) {
                        DescribeTaskListOperation.addValues(rowSet, execution.getEID(), execution.getCaller(), DescribeTaskListOperation.skipNull(execution.getJobName()), DescribeTaskListOperation.skipNull((Object)taskExec.getExecutionMode()), taskExec.getTaskName(), DescribeTaskListOperation.skipNull((Object)taskExec.getTaskType()), DescribeTaskListOperation.formatTaskWindow(taskExec), taskExec.listResumptionStates(), DescribeTaskListOperation.formatWeight(taskExec.getWeight(), true), taskExec.isAutoComplete(), taskExec.getUndoLimit(), taskExec.getUndoCount(), DescribeTaskListOperation.formatExecTime(execution.getUntilTime()), DescribeTaskListOperation.skipNull((Object)taskExec.getCompletionState()), DescribeTaskListOperation.formatExecTime(taskExec.getCompletionStartTime()), DescribeTaskListOperation.formatExecTime(taskExec.getCompletionEndTime()), DescribeTaskListOperation.skipNull(taskExec.getFacets()), DescribeTaskListOperation.skipNull((Object)taskExec.getState()), DescribeTaskListOperation.formatExecTime(taskExec.getStartTime()), DescribeTaskListOperation.formatExecTime(taskExec.getEndTime()), taskExec.getErrorCode(), DescribeTaskListOperation.skipNull(taskExec.getErrorMessage()));
                    }
                }
            } else {
                rowSet = new RowSet(DescribeTaskListOperation.createResultDescriptorExecSummary());
                for (TaskListExecution execution : executions) {
                    DescribeTaskListOperation.addValues(rowSet, execution.getEID(), execution.getCaller(), DescribeTaskListOperation.skipNull(execution.getJobName()), DescribeTaskListOperation.skipNull((Object)execution.getExecutionMode()), DescribeTaskListOperation.skipNull((Object)execution.getState()), DescribeTaskListOperation.formatWeight(execution.getTotalProgress(), true), DescribeTaskListOperation.formatExecTime(execution.getStartTime()), DescribeTaskListOperation.formatExecTime(execution.getEndTime()), execution.getTaskStates(), DescribeTaskListOperation.getTaskFacets(execution));
                }
            }
        }
        return rowSet;
    }

    private static List<TaskListExecution> getExecutions(Scheduler scheduler, Definition definition) throws Exception {
        AbstractSchedulerOperation.ExecDefinition exec = definition.exec;
        String listName = DescribeTaskListOperation.getTaskListName(definition.statement);
        if (exec.eid != null) {
            return Arrays.asList(DescribeTaskListOperation.getExecution(scheduler, definition));
        }
        if (exec.last) {
            List<TaskListExecution> executions = exec.N == -1 ? (exec.fromTime != null || exec.toTime != null ? (exec.orderByAsc == null ? scheduler.getExecutions(listName, exec.fromTime, exec.toTime) : scheduler.getExecutions(listName, exec.fromTime, exec.toTime, exec.orderByAsc)) : (exec.orderByAsc == null ? scheduler.getExecutions(listName) : scheduler.getExecutions(listName, exec.orderByAsc))) : (exec.N == 1 ? DescribeTaskListOperation.asList(scheduler.getLastExecution(listName)) : (exec.orderByAsc == null ? scheduler.getLastExecutions(listName, exec.N) : scheduler.getLastExecutions(listName, exec.N, exec.orderByAsc)));
            return DescribeTaskListOperation.filterByTaskFacets(executions, exec.condition);
        }
        return DescribeTaskListOperation.asList(DescribeTaskListOperation.lookupTaskList(scheduler, listName).getExecution());
    }

    private static List<TaskListExecution> asList(TaskListExecution execution) {
        return execution != null ? Arrays.asList(execution) : Collections.emptyList();
    }

    private static int getExecutionsNumber(Scheduler scheduler, Definition definition) throws Exception {
        if (definition.exec.fromTime != null || definition.exec.toTime != null) {
            return scheduler.getExecutionsNumber(DescribeTaskListOperation.getTaskListName(definition.statement), definition.exec.fromTime, definition.exec.toTime);
        }
        return scheduler.getExecutionsNumber(DescribeTaskListOperation.getTaskListName(definition.statement));
    }

    private static int getIndex(Integer index) {
        return index != null ? index : -1;
    }

    private static List<Object> getTaskFacets(TaskListExecution execution) {
        return execution.getTaskExecutions().stream().map(AbstractExecution::getFacets).map(facets -> facets == null ? "n/a" : facets.toString()).collect(Collectors.toList());
    }

    private static void addExceptionTask(RowSet rowSet, ExceptionTask task) {
        DescribeTaskListOperation.addValues(rowSet, new Object[]{task.getName(), task.getType().name(), DescribeTaskListOperation.formatTaskWindow(task), task.getState()});
    }

    private static RowMetaData createResultDescriptorTasks() {
        RowMetaData result = new RowMetaData();
        DescribeTaskListOperation.addColumn(result, "Name");
        DescribeTaskListOperation.addColumn(result, "Type");
        DescribeTaskListOperation.addColumn(result, "After Task");
        DescribeTaskListOperation.addColumn(result, "Conditional");
        DescribeTaskListOperation.addColumn(result, "Rule Set");
        DescribeTaskListOperation.addColumn(result, "Task Window");
        DescribeTaskListOperation.addColumn(result, "Resume On");
        DescribeTaskListOperation.addColumn(result, "Exception");
        DescribeTaskListOperation.addColumn(result, "Weight");
        DescribeTaskListOperation.addColumn(result, "Auto Complete");
        DescribeTaskListOperation.addColumn(result, "RPL Script");
        DescribeTaskListOperation.addColumn(result, "State");
        return result;
    }

    private static RowMetaData createResultDescriptorExceptions() {
        RowMetaData result = new RowMetaData();
        DescribeTaskListOperation.addColumn(result, "Task");
        DescribeTaskListOperation.addColumn(result, "Type");
        DescribeTaskListOperation.addColumn(result, "Task Window");
        DescribeTaskListOperation.addColumn(result, "State");
        return result;
    }

    private static RowMetaData createResultDescriptorRuleSets() {
        RowMetaData result = new RowMetaData();
        DescribeTaskListOperation.addColumn(result, "Name");
        DescribeTaskListOperation.addColumn(result, "On Task");
        DescribeTaskListOperation.addColumn(result, "Rules");
        return result;
    }

    private static RowMetaData createResultDescriptorTriggers() {
        RowMetaData result = new RowMetaData();
        DescribeTaskListOperation.addColumn(result, "Name");
        DescribeTaskListOperation.addColumn(result, "Job");
        DescribeTaskListOperation.addColumn(result, "Task");
        DescribeTaskListOperation.addColumn(result, "Enabled");
        return result;
    }

    private static RowMetaData createResultDescriptorExecAll() {
        RowMetaData result = new RowMetaData();
        DescribeTaskListOperation.addColumn(result, "Execution ID");
        DescribeTaskListOperation.addColumn(result, "Caller");
        DescribeTaskListOperation.addColumn(result, "Job");
        DescribeTaskListOperation.addColumn(result, "Execution Mode");
        DescribeTaskListOperation.addColumn(result, "Task Name");
        DescribeTaskListOperation.addColumn(result, "Task Type");
        DescribeTaskListOperation.addColumn(result, "Task Window");
        DescribeTaskListOperation.addColumn(result, "Resume On");
        DescribeTaskListOperation.addColumn(result, "Weight");
        DescribeTaskListOperation.addColumn(result, "Auto Complete");
        DescribeTaskListOperation.addColumn(result, "Undo Limit");
        DescribeTaskListOperation.addColumn(result, "Undo Count");
        DescribeTaskListOperation.addColumn(result, "Until Time");
        DescribeTaskListOperation.addColumn(result, "Completion State");
        DescribeTaskListOperation.addColumn(result, "Completion Start Time");
        DescribeTaskListOperation.addColumn(result, "Completion End Time");
        DescribeTaskListOperation.addColumn(result, "Completion Facets");
        DescribeTaskListOperation.addColumn(result, "Execution State");
        DescribeTaskListOperation.addColumn(result, "Execution Start Time");
        DescribeTaskListOperation.addColumn(result, "Execution End Time");
        DescribeTaskListOperation.addColumn(result, "Error Code");
        DescribeTaskListOperation.addColumn(result, "Error Message");
        return result;
    }

    private static RowMetaData createResultDescriptorExecSummary() {
        RowMetaData result = new RowMetaData();
        DescribeTaskListOperation.addColumn(result, "Execution ID");
        DescribeTaskListOperation.addColumn(result, "Caller");
        DescribeTaskListOperation.addColumn(result, "Job");
        DescribeTaskListOperation.addColumn(result, "Execution Mode");
        DescribeTaskListOperation.addColumn(result, "State");
        DescribeTaskListOperation.addColumn(result, "Progress");
        DescribeTaskListOperation.addColumn(result, "Start Time");
        DescribeTaskListOperation.addColumn(result, "End Time");
        DescribeTaskListOperation.addColumn(result, "Task States");
        DescribeTaskListOperation.addColumn(result, "Completion Facets");
        return result;
    }

    static class Definition
    extends AbstractTaskListOperation.AbstractDescribeDefinition {
        Definition(AbstractSchedulerOperation operation, DSLStatement statement) throws ParsingException {
            super(operation, statement);
        }
    }
}

