/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractRuleSetOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.Rule;
import com.streamscape.sef.scheduler.RuleSet;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;

public class DescribeRuleSetOperation
extends AbstractRuleSetOperation {
    public static final String NAME = "describe ruleset";

    public DescribeRuleSetOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE RULESET").addActionParameter(new AbstractRuleSetOperation.FullRuleSetNameParameter((AbstractRuleSetOperation)this, (TaskListState[])null));
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("DESCRIPTION"))).addModifier(new Modifier("RULES")));
        this.syntax.setDescription("Shows information about a specified Rule Set in a specified Task List.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   description - Shows the Rule description.\n   rules       - Shows a list of all Rules in the Rule Set.");
        this.syntax.setExamples("describe ruleset TestList.RuleSet1\ndescribe ruleset TestList.RuleSet1 description\ndescribe ruleset TestList.RuleSet1 rules");
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        RuleSet ruleSet = this.lookupRuleSet(scheduler, definition);
        RowSet rowSet = null;
        if (definition.statement.existsModifier("DESCRIPTION")) {
            rowSet = new RowSet(DescribeRuleSetOperation.createResultDescriptorDescription());
            DescribeRuleSetOperation.addValues(rowSet, DescribeRuleSetOperation.skipNull(ruleSet.getDescription()));
        } else if (definition.statement.existsModifier("RULES")) {
            rowSet = new RowSet(DescribeRuleSetOperation.createResultDescriptorRules());
            for (Rule rule : ruleSet.getRules()) {
                DescribeRuleSetOperation.addValues(rowSet, rule.getName(), rule.getCondition(), rule.getExecTaskName());
            }
        } else {
            rowSet = new RowSet(DescribeRuleSetOperation.createSimpleResultDescriptor());
            DescribeRuleSetOperation.addValues(rowSet, "Task List", ruleSet.getTask().getTaskList().getName());
            DescribeRuleSetOperation.addValues(rowSet, "Rule Set", ruleSet.getName());
            DescribeRuleSetOperation.addValues(rowSet, "On Task", ruleSet.getTask().getName());
            DescribeRuleSetOperation.addValues(rowSet, "Rules", ruleSet.listRules());
        }
        return new SLResponse(rowSet);
    }

    private static RowMetaData createResultDescriptorRules() {
        RowMetaData result = new RowMetaData();
        DescribeRuleSetOperation.addColumn(result, "Rule Name");
        DescribeRuleSetOperation.addColumn(result, "Condition");
        DescribeRuleSetOperation.addColumn(result, "Exec Task");
        return result;
    }
}

