/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractRuleSetOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.Rule;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.modifier.Modifier;

public class DescribeRuleOperation
extends AbstractRuleSetOperation {
    public static final String NAME = "describe rule";

    public DescribeRuleOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE RULE").addActionParameter(new AbstractRuleSetOperation.FullRuleNameParameter((AbstractRuleSetOperation)this, (TaskListState[])null));
        this.syntax.addModifier(new Modifier("DESCRIPTION", false));
        this.syntax.setDescription("Shows information about a specified Rule from a specified Rule Set in a specified Task List.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   description - Shows the Rule description.");
        this.syntax.setExamples("describe rule TestList.RuleSet1.Rule1\ndescribe rule TestList.RuleSet1.Rule1 description");
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        Rule rule = this.lookupRule(scheduler, definition);
        RowSet rowSet = null;
        if (definition.statement.existsModifier("DESCRIPTION")) {
            rowSet = new RowSet(DescribeRuleOperation.createResultDescriptorDescription());
            DescribeRuleOperation.addValues(rowSet, DescribeRuleOperation.skipNull(rule.getDescription()));
        } else {
            rowSet = new RowSet(DescribeRuleOperation.createSimpleResultDescriptor());
            DescribeRuleOperation.addValues(rowSet, "Task List", rule.getRuleSet().getTask().getTaskList().getName());
            DescribeRuleOperation.addValues(rowSet, "Rule Set", rule.getRuleSet().getName());
            DescribeRuleOperation.addValues(rowSet, "Rule Name", rule.getName());
            DescribeRuleOperation.addValues(rowSet, "Condition", "when (" + rule.getCondition() + ")");
            DescribeRuleOperation.addValues(rowSet, "Exec Task", rule.getExecTaskName());
        }
        return new SLResponse(rowSet);
    }
}

