/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractModifyTaskListOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class CreateTaskListOperation
extends AbstractModifyTaskListOperation {
    public static final String NAME = "create tasklist";

    public CreateTaskListOperation() {
        this.createDSLSyntax(NAME);
        this.setAction("CREATE");
        this.addLikeModifier();
        this.addOwnerModifier();
        this.addDescriptionModifier();
        this.addTaskListWindowModifier();
        this.addTaskDelayModifier();
        this.addRetentionIntervalModifier();
        this.addPropertiesModifier(false);
        this.addTagsModifier(false);
        this.addMetasetModifier();
        this.addMetadataModifier();
        this.addAutoCompleteModifier(true);
        this.addUnorderedModifier(true);
        this.addTransactedModifier(true);
        this.addEventScopeModifier();
        this.addModelModifier();
        this.syntax.setDescription("Creates a new Task List with the specified parameters. Task Lists allow users to organize\ntasks into process chains. Chains are sequential process steps that may have conditional\nlogic branching, ideal for expressing multi-step tasks that are dependent on each other.\n\nTask Lists are best used for pipe-line processing where control logic is not complex and\ndoes not require conditional branching based on external data or correlation. Merge steps,\nRecovery and Compensating Actions are not part of Task List functionality. The primary\ngoal is to attempt execution of a step-by-step pipeline and report on success or failure.\n\nTask Lists raise many conditional events that are intended to notify observers when errors\noccur, facilitating Exception-based Process Management and human-machine interaction.\n \nAt least one Task must be added to a Task List before it may be enabled. Task Lists also\nstore overall status of their current and past execution.\n\n<b>Retention</b>\n\nUsers can specify how long to store Task List execution histories. Historical data is stored\nin the System Dataspace and available for query using Standard SQL, DSQL and BI reporting tools.\nAny tools that support Web, JDBC or OData may connect to the node and query historical results.\n\nSpecifying a retention interval means that Scheduler Histories will be periodically purged.\nReporting and query may be performed at the Task level, compared and analyzed using standard\naggregate functions such as Standard Deviation or Averages.\n\nFor more complex analysis that compares Task List effectiveness, Outliers or advanced patterns,\nusers can easily materialize results into Snapshot Tables and use built-in Statistical Library\nfunctions to analyze K-Means, Regression or Clustering based on Task execution results.\n\n<b>Event Scope</b>\n\nSpecifies the scope of the events raised or received by the Task List or its tasks.\nOBSERVABLE events may only be seen by the node that is running the Task List,\nwhereas GLOBAL will be visible to all nodes and components in the SYSPLEX.\nCLUSTER is not directly supported at this time. It's intention is to make the\nevents visible to groups of peer nodes.\n\n<b>Execution</b>\n\nWhen a Task List is executed, a new dataspace session is created and each Action Task executes\nits RPL script in this session. Once execution is complete, the session is closed.\nTransient tables can be used inside of the RPL scripts. These table's data will be assigned to\nthis Task List execution only.\n\n");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   like               - Creates a new Task List based on the existing list.\n   owner              - Owner (user or group) of the Task List.\n" + this.getMainParametersDescription("       ") + this.getMetasetDescription("       ") + this.getMetadataDescription("       "));
        this.syntax.setExamples("create tasklist Test\ncreate tasklist Test1 like Test\ncreate tasklist Test description 'Test list.' properties (name1 = 'value1') tags ('tag1')\ncreate tasklist Test retention interval 30 days\ncreate tasklist Test time window 3 minutes\ncreate tasklist Test no autocomplete\ncreate tasklist Test no autocomplete unordered\ncreate tasklist Test transacted\ncreate tasklist Test metaset TestMetaset");
    }

    @Override
    protected IdentifierParameter createTaskListNameParameter() {
        return this.doCreateTaskListNameParameter();
    }

    @Override
    protected AbstractParameter createLikeParameter() {
        return (AbstractParameter)new IdentifierParameter("SourceName").setCompletionAdviser(new AbstractSchedulerOperation.TaskListNameCompletionAdviser());
    }

    @Override
    protected String getResumeOnDescription(String indent) {
        return "";
    }

    @Override
    protected String getAutocompleteDescription() {
        return "   no autocomplete    - Indicates that " + this.doGetAutocompleteDescription();
    }

    @Override
    protected String getTransactedDescription() {
        return "   transacted         - Indicates that " + this.doGetTransactedDescription();
    }

    @Override
    protected String getPropertiesDescription(String indent) {
        return this.getPropertiesDescriptionForCreate(indent);
    }

    @Override
    protected String getTagsDescription(String indent) {
        return this.getTagsDescriptionForCreate(indent);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        TaskList taskList = CreateTaskListOperation.createTaskList(scheduler, definition);
        try {
            this.setOwner(scheduler, definition);
            CreateTaskListOperation.setDescription(taskList, definition);
            CreateTaskListOperation.setTaskListWindow(taskList, definition);
            CreateTaskListOperation.setTaskDelay(taskList, definition);
            CreateTaskListOperation.setRetentionInterval(taskList, definition);
            CreateTaskListOperation.setProperties(taskList, definition);
            CreateTaskListOperation.addTags(taskList, definition);
            this.setMetaset(taskList, definition);
            CreateTaskListOperation.setMetadata(taskList, definition);
            CreateTaskListOperation.setAutoComplete(taskList, definition);
            CreateTaskListOperation.setUnordered(taskList, definition);
            CreateTaskListOperation.setTransacted(taskList, definition);
            this.setEventScope(taskList, definition);
            CreateTaskListOperation.setModel(taskList, definition);
            scheduler.updateTaskList(taskList);
        }
        catch (Exception exception) {
            scheduler.dropTaskList(taskList.getName());
            throw exception;
        }
        return new SLResponse();
    }
}

