/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractModifyTaskOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.ActionTask;
import com.streamscape.sef.scheduler.EventTask;
import com.streamscape.sef.scheduler.ExceptionTask;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.Task;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.Modifier;

public class AlterTaskOperation
extends AbstractModifyTaskOperation<Task> {
    public static final String NAME = "alter task";

    public AlterTaskOperation() {
        super(NAME, null);
        this.syntax.setAction("ALTER TASK").addActionParameter(new AbstractSchedulerOperation.FullTaskNameParameterWithException((AbstractSchedulerOperation)this, TaskListState.DISABLED));
        this.addNameModifier();
        this.addDescriptionModifier();
        this.addTaskWindowModifier();
        this.addResumeOnModifier();
        this.addClearRemovePropertiesModifier();
        this.addPropertiesModifier(true);
        this.addClearRemoveTagsModifier();
        this.addTagsModifier(true);
        this.addAfterTaskModifier(AlterTaskOperation::getTaskListNameFromScript);
        this.addWeightModifier();
        this.addOtherModifiers();
        this.addMetadataModifier();
        this.syntax.setDescription("Alters a specified Task in a specified Task List. The Task List must be in a disabled state.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   name        - New name of the Task.\n" + this.getMainParametersDescription("") + this.getSpecificParametersDescription() + this.getMetadataDescription(""));
        this.syntax.setExamples(this.getExamplePrefix() + " name Task2\n" + this.getExamplePrefix() + " after start\nalter task TestList.Task1 after Task1\n" + this.getExamplePrefix() + " task window 60 seconds resume on (failed)\n" + this.getExamplePrefix() + " description 'Test task.' put properties (name1 = 'value1') clear tags\n" + this.getExamplePrefix() + " clear properties remove tags ('tags1') add tags ('tag2','tag3')\n" + this.getExamplePrefix() + " weight 20\n" + this.getSpecificExamples());
    }

    @Override
    protected void addConditionModifier(boolean forAdd) {
        this.syntax.addModifier(new Modifier("CLEAR CONDITION", false));
        super.addConditionModifier(false);
    }

    protected void addOtherModifiers() {
        this.addUndoLimitModifier();
        this.addModelModifier();
        this.addScriptModifier(false);
        this.addEncryptDecryptModifier();
    }

    protected static Pair<String, String> getTaskListNameFromScript(String script) {
        return AlterTaskOperation.getFullTaskListNameFromScript(script, NAME);
    }

    @Override
    protected String getPropertiesDescription(String indent) {
        return this.getPropertiesDescriptionForAlter(indent);
    }

    @Override
    protected String getTagsDescription(String indent) {
        return this.getTagsDescriptionForAlter(indent);
    }

    @Override
    protected String getSpecificParametersDescription() {
        return super.getSpecificParametersDescription() + "\n   undo limit  - Maximum possible number of consecutive calls to the Task API method 'undo' in the RPL script.\n   model       - Task model.\n   as          - RPL script that is performed during Task execution.\n   no rpl      - Removes the RPL script.\n   encrypt     - Allows showing the RPL script only to the Task owner or administrator.\n   decrypt     - Allows showing the RPL script to any user.\n                 Parameters 'undo limit', 'model', 'as', 'encrypt', 'decrypt' are applicable to Action Task only.";
    }

    @Override
    protected String getAfterParameterDescription() {
        return super.getAfterParameterDescription() + "\n                    null  - Indicates that the Task will not be executed at all.";
    }

    @Override
    protected String getExamplePrefix() {
        return "alter task TestList.Task1";
    }

    @Override
    protected String getSpecificExamples() {
        return this.getExamplePrefix() + " event scope global\n" + this.getExamplePrefix() + " as { log.info(getCurrentUser()); }\n" + this.getExamplePrefix() + " no rpl\n" + this.getExamplePrefix() + " undo limit 5";
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        this.checkParametersPresence(statement);
        return super.convertDslToSl(statement);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        TaskList taskList = AlterTaskOperation.lookupTaskList(scheduler, definition);
        Task task = this.lookupTask(taskList, definition);
        AlterTaskOperation.setAfterTask(taskList, task, definition);
        AlterTaskOperation.setName(task, definition);
        AlterTaskOperation.setDescription(task, definition);
        AlterTaskOperation.setTaskWindow(task, definition);
        AlterTaskOperation.setResumeOn(task, definition);
        AlterTaskOperation.clearProperties(task, definition);
        AlterTaskOperation.removeProperties(task, definition);
        AlterTaskOperation.setProperties(task, definition);
        AlterTaskOperation.clearTags(task, definition);
        AlterTaskOperation.removeTags(task, definition);
        AlterTaskOperation.addTags(task, definition);
        AlterTaskOperation.setWeight(task, definition);
        this.setOtherParameters(task, definition);
        AlterTaskOperation.setMetadata(task, definition);
        scheduler.updateTaskList(taskList);
        return new SLResponse();
    }

    @Override
    protected Task lookupTask(TaskList taskList, AbstractSchedulerOperation.Definition definition) throws Exception {
        Task result = super.lookupTask(taskList, definition);
        if (result instanceof EventTask) {
            if (definition.statement.existsParameter("UndoLimit")) {
                throw new Exception("Parameter 'undo limit' is not applicable to EVENT Task.");
            }
            if (definition.statement.existsParameter("Model")) {
                throw new Exception("Parameter 'model' is not applicable to EVENT Task.");
            }
            if (definition.statement.existsModifier("NO RPL")) {
                throw new Exception("Parameter 'no rpl' is not applicable to EVENT Task.");
            }
            if (definition.statement.existsParameter("RPL")) {
                throw new Exception("Parameter 'as' is not applicable to EVENT Task.");
            }
            if (definition.statement.existsModifier("ENCRYPT")) {
                throw new Exception("Parameter 'encrypt' is not applicable to EVENT Task.");
            }
            if (definition.statement.existsModifier("DECRYPT")) {
                throw new Exception("Parameter 'decrypt' is not applicable to EVENT Task.");
            }
        } else if (result instanceof ExceptionTask) {
            if (definition.statement.existsParameter("UndoLimit")) {
                throw new Exception("Parameter 'undo limit' is not applicable to EXCEPTION Task.");
            }
            if (definition.statement.existsParameter("Model")) {
                throw new Exception("Parameter 'model' is not applicable to EXCEPTION Task.");
            }
        }
        return result;
    }

    protected void setOtherParameters(Task task, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (task instanceof ActionTask) {
            if (!(task instanceof ExceptionTask)) {
                AlterTaskOperation.setUndoLimit((ActionTask)task, definition);
                AlterTaskOperation.setModel((ActionTask)task, definition);
            }
            AlterTaskOperation.setScript((ActionTask)task, definition);
            AlterTaskOperation.setEncrypted((ActionTask)task, definition);
        }
    }
}

