/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractModifyTaskListOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.DataspaceVariableReferenceParameter;
import java.util.List;

public class AlterTaskListOperation
extends AbstractModifyTaskListOperation {
    public static final String NAME = "alter tasklist";

    public AlterTaskListOperation() {
        this.createDSLSyntax(NAME);
        this.setAction("ALTER", TaskListState.DISABLED);
        this.addNameModifier();
        this.addOwnerModifier();
        this.addDescriptionModifier();
        this.addTaskListWindowModifier();
        this.addTaskDelayModifier();
        this.addRetentionIntervalModifier();
        this.addClearRemovePropertiesModifier();
        this.addPropertiesModifier(true);
        this.addClearRemoveTagsModifier();
        this.addTagsModifier(true);
        this.addMetasetModifier();
        this.addMetadataModifier();
        this.addAutoCompleteModifier(false);
        this.addUnorderedModifier(false);
        this.addTransactedModifier(false);
        this.addEventScopeModifier();
        this.addModelModifier();
        this.syntax.setDescription("Alters a specified Task List. The Task List must be in a disabled state.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   name               - New name of the Task List.\n   owner              - Owner (user or group) of the Task List.\n" + this.getMainParametersDescription("       ") + this.getMetasetDescription("") + this.getMetadataDescription("       "));
        this.syntax.setExamples("alter tasklist Test name Test1\nalter tasklist Test description 'Test list.' put properties (name1 = 'value1') clear tags\nalter tasklist Test task window 60 seconds resume on (failed)\nalter tasklist Test retention interval 10 days\nalter tasklist Test clear properties remove tags ('tags1') add tags ('tag2','tag3')\nalter tasklist Test time window 3 minutes\nalter tasklist Test autocomplete\nalter tasklist Test ordered\nalter tasklist Test transacted\nalter tasklist Test set metaset model TestMetaset\nalter tasklist Test clear metaset model\nalter tasklist Test set metaset instance @m1\nalter tasklist Test clear metaset instance");
    }

    @Override
    protected void addMetasetModifier() {
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("Metaset_ModelInstance", false).addModifier(new Modifier("CLEAR METASET MODEL"))).addModifier(new Modifier("CLEAR METASET INSTANCE"))).addModifier((AbstractModifier)new Modifier("SET METASET MODEL").addParameter(this.createMetasetNameParameterWithAdviser()))).addModifier((AbstractModifier)new Modifier("SET METASET INSTANCE").addParameter(new DataspaceVariableReferenceParameter("Metaset")))).setCompactSyntax("[{clear metaset model | set metaset model <MetasetName> |\n  clear metaset instance | set metaset instance @<Metaset>}]"));
    }

    @Override
    protected String getResumeOnDescription(String indent) {
        return "";
    }

    @Override
    protected String getAutocompleteDescription() {
        return "   [no] autocomplete  - Indicates if the Tasks should be executed in autocomplete mode or not.\n                        No autocomplete means " + this.doGetAutocompleteDescription();
    }

    @Override
    protected String getUnorderedDescription() {
        return "   ordered            - Indicates that the Tasks are chained and will be executed in a predefined order.\n" + super.getUnorderedDescription();
    }

    @Override
    protected String getTransactedDescription() {
        return "   [no] transacted    - Indicates if the RPL scripts all of Action Tasks should be executed in transacted mode or not.\n                        Transacted means " + this.doGetTransactedDescription();
    }

    @Override
    protected String getPropertiesDescription(String indent) {
        return this.getPropertiesDescriptionForAlter(indent);
    }

    @Override
    protected String getTagsDescription(String indent) {
        return this.getTagsDescriptionForAlter(indent);
    }

    @Override
    protected String getMetasetDescription(String indent) {
        return "\n   metaset model " + indent + "     - Metaset model associated with the Task List.\n" + indent + "                        Any Metaset instance used during the Task List execution must match this model.\n" + indent + "                           set   - Sets the specified Metaset model to the Task List.\n" + indent + "                           clear - Removes an existing Metaset model from the Task List.\n   metaset instance " + indent + "  - Metaset instance associated with the Task List. It's used by default during the Task List execution.\n" + indent + "                        This instance must match the Metaset model associated with the Task List.\n" + indent + "                           set   - Sets the specified Metaset instance to the Task List.\n" + indent + "                           clear - Removes an existing Metaset instance from the Task List.";
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        this.checkParametersPresence(statement);
        return super.convertDslToSl(statement);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        TaskList taskList = AlterTaskListOperation.lookupTaskList(scheduler, definition);
        this.setOwner(scheduler, definition);
        AlterTaskListOperation.setName(taskList, definition);
        AlterTaskListOperation.setDescription(taskList, definition);
        AlterTaskListOperation.setTaskListWindow(taskList, definition);
        AlterTaskListOperation.setTaskDelay(taskList, definition);
        AlterTaskListOperation.setRetentionInterval(taskList, definition);
        AlterTaskListOperation.clearProperties(taskList, definition);
        AlterTaskListOperation.removeProperties(taskList, definition);
        AlterTaskListOperation.setProperties(taskList, definition);
        AlterTaskListOperation.clearTags(taskList, definition);
        AlterTaskListOperation.removeTags(taskList, definition);
        AlterTaskListOperation.addTags(taskList, definition);
        this.setMetaset(taskList, definition);
        this.setMetasetInstance(taskList, definition, session);
        AlterTaskListOperation.setMetadata(taskList, definition);
        AlterTaskListOperation.setAutoComplete(taskList, definition);
        AlterTaskListOperation.setUnordered(taskList, definition);
        AlterTaskListOperation.setTransacted(taskList, definition);
        this.setEventScope(taskList, definition);
        AlterTaskListOperation.setModel(taskList, definition);
        if (!this.isMetasetInstanceOnly(definition)) {
            scheduler.updateTaskList(taskList);
        }
        return new SLResponse();
    }

    private boolean isMetasetInstanceOnly(AbstractSchedulerOperation.Definition definition) {
        List<String> modifiers = definition.statement.listModifiers();
        return modifiers.size() == 3 && modifiers.get(0).equals("ACTION_VERB") && modifiers.get(1).equals("Metaset_ModelInstance") && modifiers.get(2).contains("INSTANCE");
    }

    @Override
    protected void setMetaset(TaskList taskList, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("CLEAR METASET MODEL")) {
            taskList.setMetaset(null);
        } else if (definition.statement.existsModifier("SET METASET MODEL")) {
            super.setMetaset(taskList, definition);
        }
    }

    private void setMetasetInstance(TaskList taskList, AbstractSchedulerOperation.Definition definition, MFSession session) throws Exception {
        if (definition.statement.existsModifier("CLEAR METASET INSTANCE")) {
            taskList.setMetasetInstance(null);
        } else if (definition.statement.existsModifier("SET METASET INSTANCE")) {
            taskList.setMetasetInstance(this.getMetaset(definition, session));
        }
    }
}

