/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractRuleSetOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.RuleSet;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.MFSession;

public class AlterRuleSetOperation
extends AbstractRuleSetOperation {
    public static final String NAME = "alter ruleset";

    public AlterRuleSetOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER RULESET").addActionParameter(new AbstractRuleSetOperation.FullRuleSetNameParameter((AbstractRuleSetOperation)this, TaskListState.DISABLED));
        this.addNameModifier();
        this.addDescriptionModifier();
        this.syntax.setDescription("Alters a specified Rule Set in a specified Task List.\nThe Task List must be in a disabled state.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   name        - New name of the Rule Set.\n   description - " + AlterRuleSetOperation.getDescriptionDescription());
        this.syntax.setExamples("alter ruleset TestList.RuleSet1 name RuleSet2\nalter ruleset TestList.RuleSet1 description 'Test Rule Set.'");
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        TaskList taskList = AlterRuleSetOperation.lookupTaskList(scheduler, definition);
        RuleSet ruleSet = this.lookupRuleSet(taskList, definition);
        AlterRuleSetOperation.setName(ruleSet, definition);
        AlterRuleSetOperation.setDescription(ruleSet, definition);
        scheduler.updateTaskList(taskList);
        return new SLResponse();
    }
}

