/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractRuleSetOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.Rule;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.MFSession;

public class AlterRuleOperation
extends AbstractRuleSetOperation {
    public static final String NAME = "alter rule";

    public AlterRuleOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER RULE").addActionParameter(new AbstractRuleSetOperation.FullRuleNameParameter((AbstractRuleSetOperation)this, TaskListState.DISABLED));
        this.addNameModifier();
        this.addConditionModifier(false);
        this.addExecTaskModifier(false, AlterRuleOperation::getTaskListNameFromScript);
        this.addDescriptionModifier();
        this.syntax.setDescription("Alters the specified Rule (its Task List must be in a disabled state).");
        this.syntax.setDescription("Alters a specified Rule in a specified Rule Set in a specified Task List.\nThe Task List must be in a disabled state.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   name        - New name of the Rule.\n" + AlterRuleOperation.getWhenExecTaskDescription() + "\n   description - " + AlterRuleOperation.getDescriptionDescription());
        this.syntax.setExamples("alter rule TestList.RuleSet1.Rule1 name Rule2\nalter rule TestList.RuleSet1.Rule1 when (id = 102)\nalter rule TestList.RuleSet1.Rule1 exec task Task2 description 'Test Rule Set.'");
    }

    protected static Pair<String, String> getTaskListNameFromScript(String script) {
        return AlterRuleOperation.getFullTaskListNameFromScript(script, NAME);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        TaskList taskList = AlterRuleOperation.lookupTaskList(scheduler, definition);
        Rule rule = this.lookupRule(this.lookupRuleSet(taskList, definition), definition);
        AlterRuleOperation.setName(rule, definition);
        AlterRuleOperation.setDescription(rule, definition);
        if (definition.statement.existsParameter("Condition")) {
            rule.setCondition(definition.statement.getParameter("Condition").getValue());
        }
        if (definition.statement.existsModifier("EXEC TASK")) {
            rule.setExecTask(AlterRuleOperation.getTaskName(definition));
        }
        scheduler.updateTaskList(taskList);
        return new SLResponse();
    }
}

