/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractRuleSetOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

public class AddRuleSetOperation
extends AbstractRuleSetOperation {
    public static final String NAME = "add ruleset";

    public AddRuleSetOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ADD RULESET").addActionParameter((SyntaxParameter)new IdentifierParameter("RuleSetName").addExclusionValue("TO"));
        this.addToModifier(this.createTaskListNameParameter());
        this.addOnTaskModifier(true);
        this.addDescriptionModifier();
        this.syntax.setDescription("Adds a new Rule Set to a specified Task List.\nThe Task List must be in a disabled state.");
        this.syntax.setSyntaxDescription("Parameters:\n\n   on task     - Task that the new Rule Set is attached to.\n                 Only one Rule Set can be attached to one Task.\n\nOptional parameters:\n\n   description - " + AddRuleSetOperation.getDescriptionDescription());
        this.syntax.setExamples("add ruleset RuleSet1 to TestList on task Task1\nadd ruleset RuleSet1 to TestList on task Task1 description 'Test Rule Set.'");
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        TaskList taskList = AddRuleSetOperation.lookupTaskList(scheduler, definition);
        taskList.addRuleSet(AddRuleSetOperation.getRuleSetName(definition), AddRuleSetOperation.getDescription(definition), AddRuleSetOperation.getTaskName(definition));
        scheduler.updateTaskList(taskList);
        return new SLResponse();
    }
}

