/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractRuleSetOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.RuleSet;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

public class AddRuleOperation
extends AbstractRuleSetOperation {
    public static final String NAME = "add rule";

    public AddRuleOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ADD RULE").addActionParameter((SyntaxParameter)new IdentifierParameter("RuleName").addExclusionValue("TO"));
        this.addToModifier((AbstractRuleSetOperation)this.new AbstractRuleSetOperation.FullRuleSetNameParameter(TaskListState.DISABLED));
        this.addConditionModifier(true);
        this.addExecTaskModifier(true, AddRuleOperation::getTaskListNameFromScript);
        this.addDescriptionModifier();
        this.syntax.setDescription("Adds a new Rule to a specified Rule Set in a specified Task List.\nThe Task List must be in a disabled state.");
        this.syntax.setSyntaxDescription("Parameters:\n\n" + AddRuleOperation.getWhenExecTaskDescription() + "\n\nOptional parameters:\n\n   description - " + AddRuleOperation.getDescriptionDescription());
        this.syntax.setExamples("add rule Rule1 to TestList.RuleSet1 when (id = 101) exec task Task1\nadd rule Rule2 to TestList.RuleSet1 when (key1 = '1' and key2 = '2') exec task Task2 description 'Test Rule Set.'");
    }

    protected static Pair<String, String> getTaskListNameFromScript(String script) {
        return AddRuleOperation.getFullTaskListNameFromScript(script, "to");
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        TaskList taskList = AddRuleOperation.lookupTaskList(scheduler, definition);
        RuleSet ruleSet = this.lookupRuleSet(taskList, definition);
        ruleSet.addRule(AddRuleOperation.getRuleName(definition), AddRuleOperation.getDescription(definition), AddRuleOperation.getCondition(definition), AddRuleOperation.getTaskName(definition));
        scheduler.updateTaskList(taskList);
        return new SLResponse();
    }
}

