/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.mf.operation.scheduler.tasklist.AddActionTaskToListOperation;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.ExceptionTask;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.Task;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.sef.scheduler.TaskType;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.CompoundParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class AddExceptionForTaskOperation
extends AddActionTaskToListOperation {
    public static final String NAME = "add exception for";

    public AddExceptionForTaskOperation() {
        super(NAME, TaskType.EXCEPTION);
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   like        - Creates a new Exception Task based on the existing Exception Task.\n" + this.getMainParametersDescription("") + this.getSpecificParametersDescription());
        this.syntax.setExamples("add exception for TestList as { log.info(getCurrentUser()); }\nadd exception for TestList.Task1 { as { log.info(getCurrentUser()); }");
    }

    @Override
    protected void addAction() {
        this.syntax.setAction("ADD EXCEPTION FOR").addActionParameter(new FullTaskNameReducibleParameter());
    }

    @Override
    protected void addModifiers() {
        this.addLikeModifier();
        this.addDescriptionModifier();
        this.addTaskWindowModifier();
        this.addScriptModifier();
        this.addEncryptModifier();
    }

    @Override
    protected AbstractParameter createLikeParameter() {
        return (AbstractSchedulerOperation)this.new AbstractSchedulerOperation.FullTaskNameParameterWithException(this.taskType);
    }

    protected void addScriptModifier() {
        this.syntax.addModifier((AbstractModifier)this.createScriptModifier(false).setCompactSyntax("as {<RPL>}"));
    }

    @Override
    protected String doGetDescription() {
        return "Adds a new Exception Task for a specified Task. The Task List must be in a disabled state.";
    }

    @Override
    protected String getMainParametersDescription(String indent) {
        return "   description" + indent + " - " + StringUtils.toCapitalized(this.getEntity()) + " description that may contain formatting characters same as RPL documentation.\n" + this.getTaskWindowDescription(indent) + this.getSpecificParametersDescription(indent);
    }

    @Override
    protected String getSpecificParametersDescription() {
        return "\n   encrypt     - Allows showing RPL script only to the Task owner or administrator.";
    }

    @Override
    protected void checkParameters(DSLStatement statement, TaskList taskList) throws Exception {
        if (this.isScriptMissed(statement)) {
            this.throwScriptMissedException(statement);
        }
    }

    @Override
    protected ExceptionTask addTask(TaskList taskList, DSLStatement statement, MFSession session) throws SchedulerException {
        return this.addExceptionTask(taskList, statement, session);
    }

    @Override
    protected void setOtherParameters(ExceptionTask task, AbstractSchedulerOperation.Definition definition) throws Exception {
        AddExceptionForTaskOperation.setScript(task, definition);
        AddExceptionForTaskOperation.setEncrypted(task, definition);
    }

    private class FullTaskNameReducibleParameter
    extends CompoundParameter {
        FullTaskNameReducibleParameter() {
            this.setReverseOrder(true);
            this.setParametersDelimiter('.');
            this.setCompactSyntax("<TaskListName>[.<TaskName>]");
            this.addParameter(this.createParameter("TaskListName", true));
            this.addParameter(this.createParameter("TaskName", false));
            this.setCompletionAdviser(new AbstractSchedulerOperation.FullTaskNameCompletionAdviser(this, new TaskListState[]{TaskListState.DISABLED}){

                @Override
                protected boolean checkTaskList(TaskList taskList) {
                    return !taskList.existsExceptionTask();
                }

                @Override
                protected boolean checkTask(Task task) {
                    return task.getExceptionTask() == null;
                }
            }.reducible());
        }

        private IdentifierParameter createParameter(String name, boolean required) {
            return (IdentifierParameter)new IdentifierParameter(name).setRequired(required);
        }
    }
}

