/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractAddTaskOperation;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.EventTask;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskType;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class AddEventTaskToListOperation
extends AbstractAddTaskOperation<EventTask> {
    public static final String NAME = "add event task";

    public AddEventTaskToListOperation() {
        super(NAME, TaskType.EVENT);
    }

    @Override
    protected void addOtherModifiers() {
    }

    @Override
    protected String doGetDescription() {
        return "Adds a new Event Task to a specified Task List. The Task List must be in a disabled state.\n\nAn Event Task functions like a conditional event producer that raises a Scheduler Event using\nthe Event Id <b>[event.Scheduler]</b>. This event is OBSERVABLE, GLOBAL or CLUSTERED depending\non the specified EVENT SCOPE and visible to Components, Collections, Services or Actors in the\nevent fabric. It may be processed by Actors and Event Consumers across nodes or machines.\n\nIn an RPL block of a Trigger or Actor the event is accessible using this.getCurrentEvent() and\nwill contain basic information about what Task List and Node the Action Task belongs to.\nThe event also contains useful information about iteration, step and dependency of a task and will\ncontain tags, properties or MetaSet that may have been added to the Task at definition time.\n\nScheduler Events are just like any other standard Event and may be filtered using SELECTOR\nsyntax based on their source, category, tags or properties. Multiple consumers can process\nthe same Scheduler Event, allowing for complex load sharing, partitioning and distribution\nbetween cooperating participants.\n\n<b>Event Task Window</b>\n\nTasks may be given an execution window. If a task does not complete within the specified\nperiod, the task is marked EXPIRED and the next task in the list can be triggered. An Event Task\ndoes not have any associate logic as it simply Raises an Event. However execution flow may\nstill be controlled by delegating timed execution to an external mechanism or piece of logic.\n\nEvent Tasks that have an Expiration Window raise a Request. The Request will need to be\nAcknowledged using the Execution ID of the Task List instance. TaskLists and Jobs can only\nbe in serial wait-state, meaning the entire process is halted. Acknowledging a Task List will\ntell the current Step (Task) to exit the wait state. Hence you can have Task Lists and Jobs\nwith several Event Tasks that interrupt execution waiting for external Acknowledgement.\nSee the following section for how to Acknowledge Event Tasks and move the logic along in\na Task List.  \n\n<b>Acknowledging Tasks in a WAITING State</b>\n\nWhen an Event Task with a Task List execution window is defined, a Scheduler Event is raised\nas a Request. A dynamic Reply ID is created on-the-fly and added into the Event ReplyTo field.\nThe Task List then waits for a response on the Reply ID for a specified amount of time.\n\nAn event consumer (such as an Actor, Event Queue or Client Application) can then receive the\nevent, do some work and Raise an Acknowledge Event on the Event Id in the Scheduler Event's \nReplyTo property. A more detailed explanation is provided below.\n\nRaising a response may be accomplished by using RPL, API calls or simply by constructing\nand raising an acknowledgment event on the dynamic reply Event Id. After a Task Window\nexpires the internal listener of the response is destroyed and the dynamic Event Id is lost.\nIt is not possible to complete an Expired Task using an Acknowledge Event method.\n\nTo respond users can create an Acknowledgement Event in Functions, Triggers or Actors.\nThey can also use the SLANG command RAISE ACKNOWLEDGEMENT to send the response.\nWhen a Request Event is created the response ID name is placed into the ReplyTo property.\nThis is the Acknowledgement Event Id that should be used when creating or raising events.\n\nIf your event flow performs external work and then acknowledges the waiting Event Task,\nit should use the Acknowledgement Reply ID in the initial event\u2019s ReplyTo property. That\nmeans the ID or a reference to it has to be passed to every external, logic step so its available\nat the end of a flow, to acknowledge.\n\nThe Acknowledgement Reply ID has the format e.reply.<Task List Execution ID> and users\ncan look up the Execution ID using SLANG commands like DESCRIBE TASK LIST EXEC.\n\nThere are many ways to do this in the Event Fabric and Dataspace infrastructure. Some\nexamples are also provided for users to test.\n\nWhile an Event Task is in a wait-state, waiting for the timer to expire, it will show up as a\nWAITING task and the Task List will also show status as WAITING. This is in fact the real\npurpose of an Expiring Event Task. If Expiration Window is 0, the Event task will not wait.\n\n<b>Resume On</b>\n\nSee Action Task for a complete description of this feature.\n\n<b>Weight</b>\n\nTasks in a Task List are organized by ordinal value (sequence). Their order is shown using\nDESCRIBE TASK LIST and may be changed using the ALTER TASK LIST command.\n\nFor detailed information on Task Position, Task Windows and Weight see the ADD ACTION TASK\ncommand and associate documentation.\n\n<b>Event Scope</b>\n\nSpecifies the scope of the Scheduler Event. OBSERVABLE events may only be seen by the node\nthat is running the Task List, whereas GLOBAL will be visible to all nodes and components in\nthe SYSPLEX. CLUSTER is not directly supported at this time. It's intention is to make the\nevents visible to groups of peer nodes.\n\n";
    }

    @Override
    protected String getTaskWindowDescription(String indent) {
        return "   task window" + indent + " - Time period that the Task will wait for an acknowledgement on the Scheduler Event.\n              " + indent + "   Negative value means that the Task will wait for an acknowledgement without a time limit.\n              " + indent + "   Zero value means that the Task will not wait for an acknowledgement.\n";
    }

    @Override
    protected String getSpecificExamples() {
        return "";
    }

    @Override
    protected EventTask addTask(TaskList taskList, DSLStatement statement, MFSession session) throws SchedulerException {
        return this.addEventTask(taskList, statement, session);
    }

    @Override
    protected void setOtherParameters(EventTask task, AbstractSchedulerOperation.Definition definition) throws Exception {
    }
}

