/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractAddTaskOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.ActionTask;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskType;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class AddActionTaskToListOperation
extends AbstractAddTaskOperation<ActionTask> {
    public static final String NAME = "add action task";

    public AddActionTaskToListOperation() {
        this(NAME, TaskType.ACTION);
    }

    protected AddActionTaskToListOperation(String operationName, TaskType taskType) {
        super(operationName, taskType);
    }

    @Override
    protected void addOtherModifiers() {
        this.addUndoLimitModifier();
        this.addModelModifier();
        this.addScriptModifier(false);
        this.addEncryptModifier();
    }

    @Override
    protected String doGetDescription() {
        return "Adds a new Action Task to a specified Task List. The Task List must be in a disabled state.\n\nAn Action Task functions like a conditional trigger and supports standard RPL Event Trigger\nsyntax. Tasks in a Task List are organized by ordinal value (sequence). Their order is shown\nusing DESCRIBE TASK LIST and may be changed using the ALTER TASK LIST command.\n\nInternally, an Action Task is triggered by a Scheduler Event with LOCAL scope. As such it is\nonly visible to the task's RPL block. The event is accessible using this.getCurrentEvent() and\nwill contain basic information about what Task List and Node the Action Task belongs to. The\nevent also contains useful information about iteration, step and dependency of a task and will\ncontain tags, properties or MetaSet that may have been added to the Action Task at definition\ntime.\n\n<b>Action Task Window</b>\n\nTasks may be given an execution window. If a task does not complete within the specified period,\nthe step is marked EXPIRED and the next task in the list can be triggered. Note that there is no\nexplicit cancellation of the logic that runs in the RPL block as a consequence of time window\nexpiration. One way to mitigate this is through usage of a control loop in the RPL that will\nperiodically check the state of the Task. When a task state is changed to EXPIRED the logic\ncan exit the loop. If a task performs external operations such as queries or callouts to an\nexternal service (for example via Virtual Web Server or Virtual Database), it is a good idea\nto set the Timeout of such an operation to be slightly less than the size of the task window.\nThis allows the query or operation to timeout, collect the response code or message and set\nthat for the Action Task, so it may be picked and reported by the Task List scheduler.\n\n<b>Resume On</b>\n\nTasks in a Task List are chained by default, meaning one follows the other based on ordinal\nvalue (or sequential dependency). Prior to task execution the scheduler checks results of the\nprior task and then checks if the current task can proceed. Users specify under what conditions\na Task List resumes execution by using the RESUME ON clause.\n\n<b>Weight</b>\n\nTasks in a list are treated as steps in a process. As such, each task may be assigned a weight\nexpressed as integer that defines what percent of the overall process a specific task represents.\nAll tasks weights in a list must add up to 100%. The engine will validate this at task addition\ntime and throw an error if the weight is invalid. Users can check the overall completion state\nof a Task List using LIST and DESCRIBE commands as well as drive visual tools that report on\noverall completion of Task Lists in real-time. Incomplete or skipped steps will not have their\nweight added to overall completion status allowing for historical analysis of task completion.\n";
    }

    @Override
    protected String getTaskWindowDescription(String indent) {
        return "   task window" + indent + " - Time period that the Task will wait for execution of its RPL script.\n              " + indent + "   Non-positive value means that the Task will wait for the script completion without a time limit.\n";
    }

    @Override
    protected String getSpecificParametersDescription() {
        return super.getSpecificParametersDescription() + this.getUndoLimitDescription() + this.getModelDescription() + "\n   as          - RPL script that is performed during the Task execution.\n                 If the Task is not autocomplete, the RPL script can be omitted. This means that the Task\n                 will be completed immediately after receiving a Completion Event.\n   encrypt     - Allows showing RPL script only to the Task owner or administrator.";
    }

    protected String getUndoLimitDescription() {
        return "\n   undo limit  - Maximum possible number of consecutive calls to the Task API method 'undo' in the RPL script.\n                 If the limit is exceeded, the 'undo' call does nothing.\n                 Negative value means that the number of calls is not limited. Default value is 3.";
    }

    protected String getModelDescription() {
        return "\n   model       - Task model.";
    }

    @Override
    protected String getSpecificExamples() {
        return this.getExamplePrefix() + " as { log.info(getCurrentUser()); }\n" + this.getExamplePrefix() + " undo limit 5";
    }

    @Override
    protected void checkParameters(DSLStatement statement, TaskList taskList) throws Exception {
        if (this.isScriptMissed(statement) && (statement.existsModifier("AUTOCOMPLETE") ? !statement.existsModifier("NO") : taskList.isAutoComplete())) {
            this.throwScriptMissedException(statement);
        }
    }

    protected boolean isScriptMissed(DSLStatement statement) {
        return !statement.existsModifier("AS") && !statement.existsModifier("LIKE");
    }

    protected void throwScriptMissedException(DSLStatement statement) throws Exception {
        throw new ParsingException(this.getSyntaxErrorMessage("RPL script must be specified. Unexpected end of statement. Expected token 'AS' after '" + statement.getOriginalStatement() + "'."));
    }

    @Override
    protected ActionTask addTask(TaskList taskList, DSLStatement statement, MFSession session) throws SchedulerException {
        return this.addActionTask(taskList, statement, session);
    }

    @Override
    protected void setOtherParameters(ActionTask task, AbstractSchedulerOperation.Definition definition) throws Exception {
        AddActionTaskToListOperation.setUndoLimit(task, definition);
        AddActionTaskToListOperation.setModel(task, definition);
        AddActionTaskToListOperation.setScript(task, definition);
        AddActionTaskToListOperation.setEncrypted(task, definition);
    }
}

