/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.ActionTask;
import com.streamscape.sef.scheduler.ExceptionTask;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.Task;
import com.streamscape.sef.scheduler.TaskExecution;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListExecution;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.sef.scheduler.TaskState;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

abstract class AbstractTaskListOperation
extends AbstractSchedulerOperation {
    protected static final String TO = "to";
    protected static final String TO_TASKLIST = "to tasklist";
    protected static final String TO_TSKL = "to tskl";

    AbstractTaskListOperation() {
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.tasklist);
        this.syntax.setInitialVersion("3.8 Build 4");
        this.syntax.setStatus("Current. Enhancements to existing syntax planned.");
    }

    protected IdentifierParameter setAction(String action) {
        IdentifierParameter result = this.createTaskListNameParameter();
        this.syntax.setAction(action + " TASKLIST").setAlias(action + " TSKL").addActionParameter(result);
        return result;
    }

    protected void setAction(String action, TaskListState ... states) {
        this.setAction(action).setCompletionAdviser(new AbstractSchedulerOperation.TaskListNameCompletionAdviser(this, states));
    }

    protected void setTaskAction(String action, List<TaskListState> listStates, List<TaskState> taskStates) {
        this.syntax.setAction(action + " TASK").addActionParameter(new AbstractSchedulerOperation.FullTaskNameParameter((AbstractSchedulerOperation)this, listStates, taskStates));
    }

    protected void setCompleteTaskAction(String action) {
        this.setTaskAction(action, Arrays.asList(TaskListState.RUNNING, TaskListState.TASK_RUNNING), Arrays.asList(TaskState.RUNNING, TaskState.WAITING_ACK, TaskState.WAITING_COMPLETION));
    }

    protected void addToTaskListModifier() {
        this.addToModifier(this.createTaskListNameParameter());
    }

    @Override
    protected IdentifierParameter createTaskListNameParameter() {
        return this.createTaskListNameParameter(new AbstractSchedulerOperation.TaskListNameCompletionAdviser(this, TaskListState.DISABLED));
    }

    protected IdentifierParameter createTaskListNameParameter(CompletionAdviser<RuntimeContext> adviser) {
        return (IdentifierParameter)new IdentifierParameter("TaskListName").setCompletionAdviser(adviser);
    }

    protected void addToModifier(AbstractParameter parameter) {
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TO").addParameter(parameter)).setSyntaxHintSpace());
    }

    protected static Pair<String, String> getFullTaskListNameFromScript(String script, String prefix) {
        return AbstractTaskListOperation.extractTaskListName(AbstractTaskListOperation.doGetTaskListNameFromScript(script, AbstractTaskListOperation.getIndexOfTaskListNameFromScript(script, prefix)));
    }

    private static int getIndexOfTaskListNameFromScript(String script, String prefix) {
        String lcScript = script.toLowerCase();
        return AbstractTaskListOperation.skipWhitespaces(lcScript, lcScript.indexOf(prefix) + prefix.length());
    }

    private static Pair<String, String> extractTaskListName(String fullName) {
        String[] tokens = fullName.split("\\.");
        return tokens.length == 2 || tokens.length == 3 ? new Pair<String, String>(tokens[0], tokens[1]) : null;
    }

    private static String doGetTaskListNameFromScript(String script, int iStart) {
        int iEnd;
        for (iEnd = iStart; iEnd < script.length() && !Character.isWhitespace(script.charAt(iEnd)); ++iEnd) {
        }
        return script.substring(iStart, iEnd);
    }

    private static int skipWhitespaces(String script, int index) {
        while (index < script.length() && Character.isWhitespace(script.charAt(index))) {
            ++index;
        }
        return index;
    }

    protected IdentifierParameter createTaskNameParameter() {
        return this.createTaskNameParameter(null);
    }

    protected IdentifierParameter createTaskNameParameter(TaskNameCompletionAdviser adviser) {
        return this.createTaskNameParameter("TaskName", adviser);
    }

    protected IdentifierParameter createTaskNameParameter(String parameterName, TaskNameCompletionAdviser adviser) {
        return (IdentifierParameter)new IdentifierParameter(parameterName).setCompletionAdviser(adviser);
    }

    protected Task lookupTask(Scheduler scheduler, AbstractSchedulerOperation.Definition definition) throws Exception {
        return this.lookupTask(AbstractTaskListOperation.lookupTaskList(scheduler, definition.statement), definition);
    }

    protected Task lookupTask(TaskList taskList, AbstractSchedulerOperation.Definition definition) throws Exception {
        return this.lookupTask(taskList, definition.statement);
    }

    protected Task lookupTask(Scheduler scheduler, DSLStatement statement) throws Exception {
        Task task = this.doLookupTask(scheduler, statement);
        if (task instanceof ExceptionTask) {
            return task;
        }
        return this.processExceptionTask(task, statement);
    }

    protected Task lookupTask(TaskList taskList, DSLStatement statement) throws Exception {
        Task task = this.doLookupTask(taskList, statement);
        return this.processExceptionTask(task, statement);
    }

    protected Task doLookupTask(Scheduler scheduler, DSLStatement statement) throws Exception {
        return this.doLookupTask(AbstractTaskListOperation.lookupTaskList(scheduler, statement), statement);
    }

    protected Task doLookupTask(TaskList taskList, DSLStatement statement) throws Exception {
        Task result = null;
        if (AbstractTaskListOperation.getTaskName(statement).equals("Exception")) {
            result = taskList.getExceptionTask();
            if (result == null) {
                throw new Exception("Exception not found for " + AbstractTaskListOperation.toFullNameWithPrefix(taskList) + ".");
            }
        } else {
            result = taskList.getTask(AbstractTaskListOperation.getTaskName(statement));
            if (result == null) {
                throw new Exception("Task not found.");
            }
        }
        return result;
    }

    protected Task processExceptionTask(Task task, DSLStatement statement) throws Exception {
        if (AbstractTaskListOperation.hasExceptionTaskName(statement)) {
            String exceptionTaskName = AbstractTaskListOperation.getExceptionTaskName(statement);
            if (!exceptionTaskName.equalsIgnoreCase("Exception")) {
                throw new ParsingException(this.getSyntaxErrorMessage("Invalid item after &lt;TaskName&gt; parameter. Only 'Exception' allowed."));
            }
            ExceptionTask exceptionTask = task.getExceptionTask();
            if (exceptionTask == null) {
                throw new Exception("Exception not found for " + AbstractTaskListOperation.toFullNameWithPrefix(task) + ".");
            }
            return exceptionTask;
        }
        return task;
    }

    protected void setOwner(Scheduler scheduler, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("Owner")) {
            scheduler.setTaskListOwner(AbstractTaskListOperation.getTaskListName(definition.statement), definition.statement.getParameter("Owner").getValue());
        }
    }

    protected static String formatTaskWindow(Task task) {
        return AbstractTaskListOperation.formatTaskWindow(task.getTaskWindow(), task.getTaskWindowUnit());
    }

    protected static String formatTaskWindow(TaskExecution taskExecution) {
        return AbstractTaskListOperation.formatTaskWindow(taskExecution.getTaskWindow(), taskExecution.getTaskWindowUnit());
    }

    protected static String formatTaskWindow(long taskWindow, TimeUnit taskWindowUnit) {
        return AbstractTaskListOperation.formatInterval(taskWindow, taskWindowUnit);
    }

    protected static String formatWeight(Task task) {
        return AbstractTaskListOperation.formatWeight(task.getWeight(), false);
    }

    protected static String formatWeight(double weight, boolean showNull) {
        return weight != 0.0 || showNull ? AbstractTaskListOperation.doFormatWeight(weight) : "system";
    }

    private static String doFormatWeight(double weight) {
        return (int)weight + "%";
    }

    protected static TaskListExecution getExecution(Scheduler scheduler, AbstractDescribeDefinition definition) throws Exception {
        TaskListExecution result = scheduler.getExecution(AbstractTaskListOperation.getTaskListName(definition.statement), definition.exec.eid);
        if (result == null) {
            throw new Exception("Execution not found.");
        }
        return result;
    }

    protected static String getResumeOn(Task task) {
        return task.isResumptionEnabledTotally() ? "[*]" : task.listResumptionStates().toString();
    }

    protected static String formatRplScript(Task task) {
        String rpl;
        if (task instanceof ActionTask && (rpl = ((ActionTask)task).getScript()) != null) {
            return rpl.isEmpty() ? "Empty" : "Yes";
        }
        return "No";
    }

    protected static RowMetaData createResultDescriptorProperties() {
        RowMetaData result = new RowMetaData();
        AbstractTaskListOperation.addColumn(result, "Name");
        AbstractTaskListOperation.addColumn(result, "Value");
        AbstractTaskListOperation.addColumn(result, "Resolved Value");
        return result;
    }

    protected static RowMetaData createResultDescriptorTags() {
        RowMetaData result = new RowMetaData();
        AbstractTaskListOperation.addColumn(result, "Tag");
        return result;
    }

    protected class TaskNameCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser<RuntimeContext> {
        private Function<String, Pair<String, String>> taskListNameGetter;

        protected TaskNameCompletionAdviser() {
            this(null);
        }

        protected TaskNameCompletionAdviser(Function<String, Pair<String, String>> taskListNameGetter) {
            this.taskListNameGetter = taskListNameGetter == null ? this::getTaskListNameFromScript : taskListNameGetter;
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            TaskList taskList;
            Pair<String, String> taskListName = this.taskListNameGetter.apply(processedScript);
            if (taskListName != null && (taskList = ((RuntimeContext)AbstractTaskListOperation.this.callable).getScheduler().getTaskList((String)taskListName.first)) != null) {
                return this.doGetCompletions(taskList, taskListName);
            }
            return null;
        }

        protected List<String> doGetCompletions(TaskList taskList, Pair<String, String> fullName) {
            return taskList.listTasks();
        }

        protected Pair<String, String> getTaskListNameFromScript(String script) {
            return new Pair<String, Object>(AbstractTaskListOperation.doGetTaskListNameFromScript(script, AbstractTaskListOperation.getIndexOfTaskListNameFromScript(script, AbstractTaskListOperation.TO)), null);
        }
    }

    protected static class AbstractDescribeDefinition
    extends AbstractSchedulerOperation.Definition {
        boolean description;
        boolean metadata;
        boolean properties;
        boolean tags;
        AbstractSchedulerOperation.ExecDefinition exec;
        String nodeName;

        AbstractDescribeDefinition(AbstractSchedulerOperation operation, DSLStatement statement) throws ParsingException {
            super(operation.getName(), statement);
            this.description = statement.existsModifier("DESCRIPTION");
            this.metadata = statement.existsModifier("METADATA");
            this.properties = statement.existsModifier("PROPERTIES");
            this.tags = statement.existsModifier("TAGS");
            this.nodeName = AtNodeOrAtDomainModifier.getValue(statement);
            if (statement.existsModifier("EXEC")) {
                this.exec = new AbstractSchedulerOperation.ExecDefinition(operation, statement);
            }
        }
    }

    protected class AfterTaskNameCompletionAdviser
    extends TaskNameCompletionAdviser {
        protected AfterTaskNameCompletionAdviser(AbstractTaskListOperation this$0, Function<String, Pair<String, String>> taskListNameGetter) {
            super(taskListNameGetter);
        }

        @Override
        protected List<String> doGetCompletions(TaskList taskList, Pair<String, String> fullName) {
            return taskList.getTasks().stream().filter(task -> !task.getName().equals(fullName.second) && !taskList.existsNextTaskAfter(task.getOID())).map(NamedObject::getName).collect(Collectors.toList());
        }
    }

    protected class OnTaskNameCompletionAdviser
    extends TaskNameCompletionAdviser {
        protected OnTaskNameCompletionAdviser(AbstractTaskListOperation this$0) {
        }

        @Override
        protected List<String> doGetCompletions(TaskList taskList, Pair<String, String> fullName) {
            return taskList.getTasks().stream().filter(task -> task.getRuleSet() == null && !taskList.existsNextTaskAfter(task.getOID())).map(NamedObject::getName).collect(Collectors.toList());
        }
    }

    protected class ExecTaskNameCompletionAdviser
    extends TaskNameCompletionAdviser {
        protected ExecTaskNameCompletionAdviser(AbstractTaskListOperation this$0, Function<String, Pair<String, String>> taskListNameGetter) {
            super(taskListNameGetter);
        }

        @Override
        protected List<String> doGetCompletions(TaskList taskList, Pair<String, String> fullName) {
            return taskList.getTasks().stream().filter(task -> (task.getRuleSet() == null || !task.getRuleSet().getName().equals(fullName.second)) && task.getAfterTaskOID() == null && taskList.getRuleSetByExecTask(task.getOID()) == null).map(NamedObject::getName).collect(Collectors.toList());
        }
    }
}

