/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractTaskListOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.Rule;
import com.streamscape.sef.scheduler.RuleSet;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.CompoundParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

abstract class AbstractRuleSetOperation
extends AbstractTaskListOperation {
    protected static final String RULESET_NAME = "RuleSetName";
    protected static final String RULE_NAME = "RuleName";

    AbstractRuleSetOperation() {
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.setInitialVersion("3.8 Build 31");
        this.syntax.addTag(OperationTag.ruleset);
    }

    protected void addExecTaskModifier(boolean required, Function<String, Pair<String, String>> listNameGetter) {
        Modifier exec = (Modifier)new Modifier("EXEC TASK", required).addParameter(this.createTaskNameParameter(new AbstractTaskListOperation.ExecTaskNameCompletionAdviser(this, listNameGetter)));
        if (required) {
            exec.setSyntaxHintSpace();
        }
        this.syntax.addModifier(exec);
    }

    protected void addOnTaskModifier(boolean required) {
        Modifier onTask = (Modifier)new Modifier("ON TASK", required).addParameter(this.createTaskNameParameter(new AbstractTaskListOperation.OnTaskNameCompletionAdviser(this)));
        if (required) {
            onTask.setSyntaxHintSpace();
        }
        this.syntax.addModifier(onTask);
    }

    protected void addConditionModifier(boolean required) {
        Modifier condition = (Modifier)new Modifier("WHEN", required).addParameter(new ExpressionParameter("Condition", '(', ')'));
        if (required) {
            condition.setSyntaxHintSpace();
        }
        this.syntax.addModifier(condition);
    }

    protected static String getWhenExecTaskDescription() {
        return "   when        - Condition that based on the Selector and determines whether the Exec Task will be executed.\n                 This Condition uses the Task List Metaset as a source of its variables.\n   exec task   - Task that will be executed if the Condition is met.";
    }

    protected static String getDescriptionDescription() {
        return "Description that may contain formatting characters same as RPL documentation.";
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new AbstractSchedulerOperation.Definition(this.getName(), statement);
    }

    protected static String getRuleSetName(AbstractSchedulerOperation.Definition definition) {
        return definition.statement.getParameter(RULESET_NAME).getValue();
    }

    protected static String getRuleName(AbstractSchedulerOperation.Definition definition) {
        return definition.statement.getParameter(RULE_NAME).getValue();
    }

    protected static String getDescription(AbstractSchedulerOperation.Definition definition) {
        return definition.statement.existsParameter("Description") ? definition.statement.getParameter("Description").getValue() : null;
    }

    protected static String getCondition(AbstractSchedulerOperation.Definition definition) {
        return definition.statement.existsParameter("Condition") ? definition.statement.getParameter("Condition").getValue() : null;
    }

    protected RuleSet lookupRuleSet(Scheduler scheduler, AbstractSchedulerOperation.Definition definition) throws Exception {
        return this.lookupRuleSet(AbstractRuleSetOperation.lookupTaskList(scheduler, definition), definition);
    }

    protected RuleSet lookupRuleSet(TaskList taskList, AbstractSchedulerOperation.Definition definition) throws Exception {
        RuleSet result = taskList.getRuleSet(AbstractRuleSetOperation.getRuleSetName(definition));
        if (result == null) {
            throw new Exception("Rule Set not found.");
        }
        return result;
    }

    protected Rule lookupRule(Scheduler scheduler, AbstractSchedulerOperation.Definition definition) throws Exception {
        return this.lookupRule(AbstractRuleSetOperation.lookupTaskList(scheduler, definition), definition);
    }

    protected Rule lookupRule(TaskList taskList, AbstractSchedulerOperation.Definition definition) throws Exception {
        return this.lookupRule(this.lookupRuleSet(taskList, definition), definition);
    }

    protected Rule lookupRule(RuleSet ruleSet, AbstractSchedulerOperation.Definition definition) throws Exception {
        Rule result = ruleSet.getRule(AbstractRuleSetOperation.getRuleName(definition));
        if (result == null) {
            throw new Exception("Rule not found.");
        }
        return result;
    }

    protected class FullRuleNameCompletionAdviser
    extends AbstractSchedulerOperation.TaskListNameCompletionAdviser {
        protected FullRuleNameCompletionAdviser(AbstractRuleSetOperation this$0, TaskListState ... states) {
            super(states);
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            ArrayList<String> result = new ArrayList<String>();
            this.getTaskLists(session).forEach(tl -> tl.getRuleSets().forEach(ruleSet -> ruleSet.listRules().stream().sorted().forEach(ruleName -> result.add(tl.getName() + "." + ruleSet.getName() + "." + ruleName))));
            return result;
        }
    }

    protected class FullRuleNameParameter
    extends CompoundParameter {
        protected FullRuleNameParameter(TaskListState ... states) {
            this("TaskListName", AbstractRuleSetOperation.RULESET_NAME, AbstractRuleSetOperation.RULE_NAME);
            this.setCompletionAdviser(new FullRuleNameCompletionAdviser(this$0, states));
        }

        private FullRuleNameParameter(String listName, String setName, String ruleName) {
            this.setParametersDelimiter('.');
            this.addParameter(this.createParameter(listName));
            this.addParameter(this.createParameter(setName));
            this.addParameter(this.createParameter(ruleName));
        }

        private IdentifierParameter createParameter(String name) {
            return new IdentifierParameter(name);
        }
    }

    protected class FullRuleSetNameCompletionAdviser
    extends AbstractSchedulerOperation.TaskListNameCompletionAdviser {
        protected FullRuleSetNameCompletionAdviser(AbstractRuleSetOperation this$0, TaskListState ... states) {
            super(states);
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            ArrayList<String> result = new ArrayList<String>();
            this.getTaskLists(session).forEach(tl -> tl.listRules().stream().sorted().forEach(ruleSetName -> result.add(tl.getName() + "." + ruleSetName)));
            return result;
        }
    }

    protected class FullRuleSetNameParameter
    extends CompoundParameter {
        protected FullRuleSetNameParameter(TaskListState ... states) {
            this();
            this.setCompletionAdviser(new FullRuleSetNameCompletionAdviser(this$0, states));
        }

        private FullRuleSetNameParameter() {
            this("TaskListName", AbstractRuleSetOperation.RULESET_NAME);
        }

        private FullRuleSetNameParameter(String listName, String taskName) {
            this.setParametersDelimiter('.');
            this.addParameter(this.createParameter(listName));
            this.addParameter(this.createParameter(taskName));
        }

        private IdentifierParameter createParameter(String name) {
            return new IdentifierParameter(name);
        }
    }
}

