/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractModifyTaskListOperation;
import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractTaskListOperation;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.ExecutableObject;
import com.streamscape.sef.scheduler.Task;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskType;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.function.Function;

abstract class AbstractModifyTaskOperation<T extends ExecutableObject>
extends AbstractModifyTaskListOperation {
    protected TaskType taskType;

    protected AbstractModifyTaskOperation(String operationName, TaskType taskType) {
        this.taskType = taskType;
        this.createDSLSyntax(operationName);
    }

    @Override
    protected String getEntity() {
        return "Task";
    }

    protected String getTaskType() {
        return this.taskType.toString().toLowerCase();
    }

    protected void addPositionModifier() {
        this.syntax.addModifier((AbstractModifier)new Modifier("STEP", false).addParameter(new IntegerParameter("Step").setRange(1, Integer.MAX_VALUE)));
    }

    protected void addAfterTaskModifier(Function<String, Pair<String, String>> listNameGetter) {
        String[] stringArray;
        CompoundModifier compoundModifier = new CompoundModifier("AfterTaskModifier", false).addModifier(new Modifier("AFTER"));
        ChoiceModifier choiceModifier = new ChoiceModifier();
        if (listNameGetter != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "NULL";
            stringArray = stringArray2;
            stringArray2[1] = "START";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "START";
        }
        this.syntax.addModifier(compoundModifier.addModifier((AbstractModifier)choiceModifier.addPossibleValues(stringArray).addModifier((AbstractModifier)new Modifier("TASK").addParameter(this.createTaskNameParameter("AfterTaskName", new AbstractTaskListOperation.AfterTaskNameCompletionAdviser(this, listNameGetter))))));
    }

    protected void addWeightModifier() {
        this.syntax.addModifier((AbstractModifier)new Modifier("WEIGHT", false).addParameter(new IntegerParameter("Weight").setRange(0, 100)));
    }

    protected void addConditionModifier(boolean forAdd) {
        this.syntax.addModifier(new CompoundModifier(false).addModifier((AbstractModifier)new Modifier("WHEN").addParameter((SyntaxParameter)new ExpressionParameter("Condition", '(', ')').setRequired(forAdd))).addModifier((AbstractModifier)new Modifier("RULE", forAdd).addParameter(new StringParameter("RuleName"))));
    }

    @Override
    protected String getSpecificParametersDescription(String indent) {
        return "";
    }

    protected String getSpecificParametersDescription() {
        return this.getAfterParameterDescription() + "\n   weight      - Percent of the entire Task List process that this Task represents, expressed as a number.\n                 Sum of the weights of all tasks in a Task List must be 100%.\n                 If no tasks have a weight set, system values are set (proportional to tasks number).";
    }

    protected String getAfterParameterDescription() {
        return "\n   after       - Determines the position of the Task in the execution chain of the Task List.\n                    start - Indicates that the Task will be executed first.\n                    task  - Indicates that the Task will be executed after the specified Task.";
    }

    protected abstract String getSpecificExamples();

    protected abstract String getExamplePrefix();

    protected static void setAfterTask(TaskList taskList, Task task, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("AFTER")) {
            if (definition.statement.existsModifier("NULL")) {
                task.setAfterTask(null);
            } else if (definition.statement.existsModifier("START")) {
                task.setAfterTask("Start");
            } else {
                task.setAfterTask(AbstractModifyTaskOperation.getTaskName(definition.statement, "AfterTaskName"));
            }
        }
    }

    protected static void setWeight(Task task, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("Weight")) {
            task.setWeight(Byte.parseByte(definition.statement.getParameter("Weight").getValue()));
        }
    }
}

