/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.mf.operation.EventScopeModifier;
import com.streamscape.runtime.mf.operation.SetParametersModifier;
import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractTaskListOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.ActionTask;
import com.streamscape.sef.scheduler.ExecutableObject;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskState;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.LongParameter;
import com.streamscape.slex.lang.parameter.NumericParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.value.StatementSetValue;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

abstract class AbstractModifyTaskListOperation
extends AbstractTaskListOperation {
    private static final String[] UNORDERED_ONLY = new String[]{"UNORDERED"};
    private static final String[] UNORDERED = new String[]{"UNORDERED", "ORDERED"};

    AbstractModifyTaskListOperation() {
    }

    protected String getMainParametersDescription(String indent) {
        return "   description" + indent + " - " + StringUtils.toCapitalized(this.getEntity()) + " description that may contain formatting characters same as RPL documentation.\n" + this.getTaskWindowDescription(indent) + this.getResumeOnDescription(indent) + this.getSpecificParametersDescription(indent) + this.getPropertiesDescription(indent) + this.getTagsDescription(indent);
    }

    protected String getEntity() {
        return "Task List";
    }

    protected String getTaskWindowDescription(String indent) {
        return "   time window" + indent + " - Time period that the Task List will wait for execution of its Tasks.\n              " + indent + "   Non-positive value means that the Task List will wait for tasks to complete without a time limit.\n";
    }

    protected String getResumeOnDescription(String indent) {
        return "   resume on  " + indent + " - Allows to execute the next Task in the chain even if the current Task was not completed properly.\n              " + indent + "      expired     - Next Task will be executed even if the current Task has expired (meaning that\n              " + indent + "                    either waiting for Completion Event expired or execution of the Task expired).\n              " + indent + "      failed      - Next Task will be executed even if the current Task has failed (meaning that\n              " + indent + "                    a failed Completion Event has been received).\n              " + indent + "      exception   - Next Task will be executed even if an exception was thrown during execution\n              " + indent + "                    of the current Task (e.g. in RPL script of Action Task).\n              " + indent + "      interrupted - Next Task will be executed even if the current Task has been interrupted (meaning that\n              " + indent + "                    either waiting for Completion Event interrupted or execution of the Task interrupted).\n              " + indent + "      all         - Next Task will be executed regardless of the current Task state.\n              " + indent + "      none        - Next Task will not be executed if the current Task was not completed properly.\n";
    }

    protected String getSpecificParametersDescription(String indent) {
        return "   task delay         - Delay (in seconds) between execution of neighboring Tasks in the chain.\n                        A zero value means that the next Task is executed immediately after the previous Task completes.\n                        Values must not be negative. Default value is 0.\n   retention interval - Maximum time interval for storing historical records of the Task List execution.\n                        Negative value (default) means that these records will be stored infinitely.\n                        A zero value means that the historical records will not be stored at all.\n" + this.getAutocompleteDescription() + this.getUnorderedDescription() + this.getTransactedDescription() + "   event scope        - Event scope of event or advisories raised or received during Task List execution.\n                        This event scope applies to all Tasks of the Task List.\n   model              - Indicates if the Task List is a Model that is intended to be used as a template for creating other Task Lists.\n                        Model Task List cannot be enabled for execution.\n                        Task Lists created from the Model are marked with the <b>model@&lt;ModelName&gt;</b> tag.\n                        Task Lists imported from the Model are marked with the <b>modelImport@&lt;ModelName&gt;</b> tag\n                        and they are execution-only (that is, they cannot be disabled for editing).\n";
    }

    protected String getUnorderedDescription() {
        return "   unordered          - Indicates that the Tasks are not chained and will simultaneously wait for a Completion Event without any order.\n                        In this case, the Task List completes its execution when all its Tasks receive such an event.\n                        This parameter is only applicable to Task Lists that are not autocomplete (in other words, this parameter\n                        can only be specified with the 'no autocomplete' one).\n                        By default, a Task List is in ordered mode, meaning its Tasks are chained and executed in a predefined order.\n";
    }

    protected String getAutocompleteDescription() {
        return "";
    }

    protected String doGetAutocompleteDescription() {
        return "that each Task will wait for receiving a Completion Event (<b>[event.Scheduler.Completion]</b>)\n                        that can change a Task to either completed or failed state.\n                        User can send this event manually or use commands COMPLETE/FAIL TASK/TASKLIST.\n                        Once completed (but not failed), the Action Task will execute its RPL script, if one exists;\n                        the Event Task will raise a Scheduler Event (<b>[event.Scheduler]</b>).\n                        By default, a Task List is in autocomplete mode, meaning its Tasks do not wait for a Completion Event.\n                        This parameter applies to all Tasks of the Task List.\n";
    }

    protected String getTransactedDescription() {
        return "";
    }

    protected String doGetTransactedDescription() {
        return "that the RPL scripts of all Action Tasks will be executed in a single transaction,\n                        which will be committed (or rolled back) when the last task completes execution.\n                        By default, a Task List is in non-transacted mode, meaning each RPL script is executed in its own transaction.\n";
    }

    protected abstract String getPropertiesDescription(String var1);

    protected String getPropertiesDescriptionForCreate(String indent) {
        return this.doGetPropertiesDescription(indent);
    }

    protected String getPropertiesDescriptionForAlter(String indent) {
        return this.doGetPropertiesDescription(indent) + "              " + indent + "      put    - Adds a new property or replaces an existing one.\n              " + indent + "      remove - Removes the specified properties.\n              " + indent + "      clear  - Removes all properties.\n";
    }

    private String doGetPropertiesDescription(String indent) {
        return "   properties " + indent + " - List of properties (name-value pairs) that will be added to Scheduler Events\n              " + indent + "   raised by this " + this.getEntity() + " as part of its execution.\n";
    }

    protected abstract String getTagsDescription(String var1);

    protected String getTagsDescriptionForCreate(String indent) {
        return this.doGetTagsDescription(indent);
    }

    protected String getTagsDescriptionForAlter(String indent) {
        return this.doGetTagsDescription(indent) + "\n              " + indent + "      add    - Adds the specified tag.\n              " + indent + "      remove - Removes the specified tag.\n              " + indent + "      clear  - Removes all tags.";
    }

    private String doGetTagsDescription(String indent) {
        return "   tags       " + indent + " - List of tags that will be added to Scheduler Events (similar to properties).";
    }

    protected String getMetasetDescription(String indent) {
        return "\n   metaset" + indent + "     - Metaset associated with the Task List.\n" + indent + "                 Any Metaset instance used during the Task List execution must match this model.";
    }

    protected String getMetadataDescription(String indent) {
        return "\n   metadata" + indent + "    - Metadata that may contain UI-specific data in any format.";
    }

    protected void addTaskWindowModifier() {
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TASK WINDOW", false).addParameter(new NumericParameter("Window"))).addParameter((SyntaxParameter)AbstractModifyTaskListOperation.createTimeUnitParameter("TaskWindowTimeUnit").setRequired(false)));
    }

    protected void addTaskListWindowModifier() {
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TIME WINDOW", false).addParameter(new NumericParameter("Window"))).addParameter((SyntaxParameter)AbstractModifyTaskListOperation.createTimeUnitParameter("TimeWindowTimeUnit").setRequired(false)));
    }

    protected void addResumeOnModifier() {
        EnumParameter resumeOn = new EnumParameter("ResumeOnState", null).addPossibleValues("EXPIRED", "FAILED", "EXCEPTION", "INTERRUPTED", "NONE", "ALL").setDefaultValue("NONE");
        this.syntax.addModifier((AbstractModifier)new Modifier("RESUME ON", false).addParameter(new SetParameter("State", resumeOn)));
    }

    protected void addTaskDelayModifier() {
        this.syntax.addModifier((AbstractModifier)new Modifier("TASK DELAY", false).addParameter(new LongParameter("Delay").setRange(0L, Long.MAX_VALUE)));
    }

    protected void addRetentionIntervalModifier() {
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("RETENTION INTERVAL", false).addParameter(new NumericParameter("Interval"))).addParameter(AbstractModifyTaskListOperation.createTimeUnitParameter("RetentionIntervalTimeUnit", false)));
    }

    protected void addPropertiesModifier(boolean withPrefix) {
        this.syntax.addModifier(new SetParametersModifier((withPrefix ? "PUT " : "") + "PROPERTIES", "Properties", false));
    }

    protected void addClearRemovePropertiesModifier() {
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("CLEAR PROPERTIES"))).addModifier((AbstractModifier)new Modifier("REMOVE PROPERTIES").addParameter(new SetParameter("RemoveProperties", new IdentifierParameter("Name")))));
    }

    protected void addTagsModifier(boolean withPrefix) {
        this.syntax.addModifier((AbstractModifier)new Modifier((withPrefix ? "ADD " : "") + "TAGS", false).addParameter(new SetParameter("Tags", new StringParameter("Tag"))));
    }

    protected void addClearRemoveTagsModifier() {
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("CLEAR TAGS"))).addModifier((AbstractModifier)new Modifier("REMOVE TAGS").addParameter(new SetParameter("RemoveTags", new StringParameter("Tag")))));
    }

    protected void appendEnableModifier(DSLStatementSyntax syntax) {
        syntax.addModifier(new Modifier("ENABLE", false));
    }

    protected void addMetasetModifier() {
        this.syntax.addModifier((AbstractModifier)new Modifier("METASET", false).addParameter(this.createMetasetNameParameterWithAdviser()));
    }

    protected void addMetadataModifier() {
        this.syntax.addModifier((AbstractModifier)new Modifier("METADATA", false).addParameter(new StringParameter("Metadata")));
    }

    protected void addAutoCompleteModifier(boolean isNoRequired) {
        this.syntax.addModifier(new CompoundModifier(false).addModifier((AbstractModifier)new Modifier("NO", isNoRequired).setName("NoAutocomplete")).addModifier(new Modifier("AUTOCOMPLETE")));
    }

    protected void addUnorderedModifier(boolean unorderedOnly) {
        this.syntax.addModifier(new ChoiceModifier(false).addPossibleValues(unorderedOnly ? UNORDERED_ONLY : UNORDERED));
    }

    protected void addEventScopeModifier() {
        this.syntax.addModifier(new EventScopeModifier(EventScope.GLOBAL));
    }

    protected void addUndoLimitModifier() {
        this.syntax.addModifier((AbstractModifier)new Modifier("UNDO LIMIT", false).addParameter(new IntegerParameter("UndoLimit").setRange(-1, Integer.MAX_VALUE)));
    }

    protected void addTransactedModifier(boolean forCreate) {
        if (forCreate) {
            this.syntax.addModifier(new Modifier("TRANSACTED", false));
        } else {
            this.syntax.addModifier(((CompoundModifier)new CompoundModifier(false).setName("CompoundTransacted")).addModifier((AbstractModifier)new Modifier("NO", false).setName("NoTransacted")).addModifier(new Modifier("TRANSACTED")));
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new AbstractSchedulerOperation.Definition(this.getName(), statement);
    }

    protected static void setTaskWindow(ExecutableObject object, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("Window")) {
            object.setTaskWindow(Long.parseLong(definition.statement.getParameter("Window").getValue()));
            if (definition.statement.existsParameter("TaskWindowTimeUnit")) {
                object.setTaskWindowUnit(TimeUnit.valueOf(definition.statement.getParameter("TaskWindowTimeUnit").getValue().toUpperCase()));
            } else {
                object.setTaskWindowUnit(TimeUnit.SECONDS);
            }
        }
    }

    protected static void setResumeOn(ExecutableObject object, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("RESUME ON")) {
            object.disableResumptionTotally();
            StatementSetValue set = definition.statement.getSet("State");
            for (int i = 0; i < set.size(); ++i) {
                String value = set.getElement(i).getParameter("ResumeOnState").getValue();
                if (value.equals("NONE")) {
                    object.disableResumptionTotally();
                    continue;
                }
                if (value.equals("ALL")) {
                    object.enableResumptionTotally();
                    continue;
                }
                if (value.equals("EXPIRED")) {
                    object.enableResumptionOn(TaskState.EXPIRED_INCOMPLETE);
                    object.enableResumptionOn(TaskState.EXECUTION_EXPIRED);
                    continue;
                }
                if (value.equals("INTERRUPTED")) {
                    object.enableResumptionOn(TaskState.INTERRUPTED_INCOMPLETE);
                    object.enableResumptionOn(TaskState.EXECUTION_INTERRUPTED);
                    continue;
                }
                if (value.equals("FAILED")) {
                    object.enableResumptionOn(TaskState.FAILED);
                    continue;
                }
                if (!value.equals("EXCEPTION")) continue;
                object.enableResumptionOn(TaskState.EXECUTION_EXCEPTION);
            }
        }
    }

    protected static void setTaskListWindow(TaskList taskList, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("Window")) {
            taskList.setTaskListWindow(Long.parseLong(definition.statement.getParameter("Window").getValue()));
            if (definition.statement.existsParameter("TimeWindowTimeUnit")) {
                taskList.setTaskListWindowUnit(TimeUnit.valueOf(definition.statement.getParameter("TimeWindowTimeUnit").getValue().toUpperCase()));
            } else {
                taskList.setTaskWindowUnit(TimeUnit.SECONDS);
            }
        }
    }

    protected static void setTaskDelay(TaskList taskList, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("Delay")) {
            taskList.setTaskDelay(Long.parseLong(definition.statement.getParameter("Delay").getValue()));
        }
    }

    protected static void setRetentionInterval(TaskList taskList, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("Interval")) {
            taskList.setRetentionInterval(Long.parseLong(definition.statement.getParameter("Interval").getValue()));
        }
        if (definition.statement.existsParameter("RetentionIntervalTimeUnit")) {
            taskList.setRetentionIntervalUnit(TimeUnit.valueOf(definition.statement.getParameter("RetentionIntervalTimeUnit").getValue().toUpperCase()));
        }
    }

    protected static void setProperties(ExecutableObject object, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("Properties")) {
            for (Map.Entry<String, String> entry : SetParametersModifier.getValue(definition.statement, "Properties").entrySet()) {
                object.putProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    protected static void clearProperties(ExecutableObject object, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("CLEAR PROPERTIES")) {
            object.clearProperties();
        }
    }

    protected static void removeProperties(ExecutableObject object, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("RemoveProperties")) {
            StatementSetValue set = definition.statement.getSet("RemoveProperties");
            for (String name : IntStream.range(0, set.size()).mapToObj(i -> set.getElement(i).getParameter("Name").getValue()).collect(Collectors.toSet())) {
                object.removeProperty(name);
            }
        }
    }

    protected static void addTags(ExecutableObject object, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("Tags")) {
            StatementSetValue set = definition.statement.getSet("Tags");
            for (String tag : IntStream.range(0, set.size()).mapToObj(i -> set.getElement(i).getParameter("Tag").getValue()).collect(Collectors.toSet())) {
                object.addTag(tag);
            }
        }
    }

    protected static void clearTags(ExecutableObject object, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("CLEAR TAGS")) {
            object.clearTags();
        }
    }

    protected static void removeTags(ExecutableObject object, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("RemoveTags")) {
            StatementSetValue set = definition.statement.getSet("RemoveTags");
            for (String tag : IntStream.range(0, set.size()).mapToObj(i -> set.getElement(i).getParameter("Tag").getValue()).collect(Collectors.toSet())) {
                object.removeTag(tag);
            }
        }
    }

    protected void setMetaset(TaskList taskList, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("MetasetName")) {
            taskList.setMetaset(AbstractModifyTaskListOperation.getMetasetName(definition.statement));
        }
    }

    protected static void setMetadata(ExecutableObject object, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("Metadata")) {
            object.setMetadata(definition.statement.getParameter("Metadata").getValue());
        }
    }

    protected static void setUndoLimit(ActionTask task, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("UndoLimit")) {
            task.setUndoLimit(Integer.parseInt(definition.statement.getParameter("UndoLimit").getValue()));
        }
    }

    protected static void setModel(ActionTask task, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("Model")) {
            task.setModel(definition.statement.getParameter("Model").getValue());
        }
    }

    protected static void setScript(ActionTask task, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("NO RPL")) {
            task.setScript(null);
        } else if (definition.statement.existsParameter("RPL")) {
            task.setScript(AbstractModifyTaskListOperation.getScript(definition.statement));
        }
    }

    protected static void setEncrypted(ActionTask task, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("ENCRYPT")) {
            task.setEncrypted(true);
        }
        if (definition.statement.existsModifier("DECRYPT")) {
            task.setEncrypted(false);
        }
    }

    protected static void setAutoComplete(TaskList taskList, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("AUTOCOMPLETE")) {
            taskList.setAutoComplete(!definition.statement.existsModifier("NoAutocomplete"));
        }
    }

    protected static void setUnordered(TaskList taskList, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("UNORDERED")) {
            taskList.setUnordered(true);
        } else if (definition.statement.existsModifier("ORDERED")) {
            taskList.setUnordered(false);
        }
    }

    protected void setEventScope(TaskList taskList, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (EventScopeModifier.hasValue(this.syntax, definition.statement)) {
            taskList.setEventScope(EventScopeModifier.getValue(this.syntax, definition.statement));
        }
    }

    protected static void setTransacted(TaskList taskList, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("TRANSACTED")) {
            taskList.setTransacted(!definition.statement.existsModifier("NoTransacted"));
        }
    }

    protected static void setModel(TaskList taskList, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("MODEL")) {
            taskList.setModel();
        }
    }
}

