/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractTaskListOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.ActionTask;
import com.streamscape.sef.scheduler.ExecutionListener;
import com.streamscape.sef.scheduler.ExecutionMode;
import com.streamscape.sef.scheduler.Task;
import com.streamscape.sef.scheduler.TaskExecution;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListExecution;
import com.streamscape.sef.scheduler.TaskType;
import com.streamscape.sef.utils.Utils;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.DataspaceVariableReferenceParameter;
import com.streamscape.slex.lang.parameter.DateParameter;
import java.util.Date;
import java.util.stream.Collectors;

abstract class AbstractExecOperation
extends AbstractTaskListOperation {
    protected AbstractExecOperation(String operationName) {
        this.createDSLSyntax(operationName);
        this.setAction();
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("METASET", false).addParameter(new DataspaceVariableReferenceParameter("Metaset"))).setSyntaxHintSpace());
        this.addUntilModifier();
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.addModifier((AbstractModifier)new Modifier("WITH WAIT", false).setName("WithWait"));
        this.syntax.setDescription(this.doGetDescription());
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   metaset       - Metaset (set of key-value pairs) that is accessible by Task List and its Tasks during execution.\n" + this.getUntilDescription() + "   at node       - Executes this command in the specified node.\n   at domain     - Executes this command in all nodes of Sysplex.\n   with wait     - Performs this operation in blocking mode (waits until completion or reply timeout expiration).\n                   This option is intended for use in scripts." + this.doGetTimeFormat());
        this.syntax.setExamples(this.doGetExamples());
    }

    protected abstract void setAction();

    protected void addUntilModifier() {
        this.syntax.addModifier(new CompoundModifier(false).addModifier((AbstractModifier)new Modifier("UNTIL").addParameter(new DateParameter("Time", SCHEDULER_DATE_FORMAT))).addModifier(new Modifier("AUTOEXPIRE", false)));
    }

    protected abstract String doGetDescription();

    protected String getUntilDescription() {
        return "   until         - Time until the execution must be completed.\n      autoexpire - Indicates whether the execution will be started and expire immediately if the until time is in the past.\n";
    }

    protected abstract String doGetExamples();

    protected String doGetTimeFormat() {
        return AbstractExecOperation.getTimeFormat("\n\n");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new AbstractSchedulerOperation.Definition(this.getName(), statement);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        return this.invoke(AtNodeOrAtDomainModifier.getValue(definition.statement), statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        if (definition.statement.existsModifier("WithWait")) {
            return this.doInvoke(definition, (MFSession)session, timeout);
        }
        FabricThreadManager.getInstance().createThread(this.getThreadName(), this.getThreadDescription(), () -> {
            Utils.sleep(500L);
            try {
                this.doInvoke(definition, (MFSession)session, timeout);
                this.raiseSLMessage(null, session);
            }
            catch (Throwable exception) {
                this.processError(exception, session);
            }
        }).start();
        return new PseudoSLResponse();
    }

    protected abstract String getThreadName();

    protected abstract String getThreadDescription();

    protected abstract SLResponse doInvoke(AbstractSchedulerOperation.Definition var1, MFSession var2, long var3) throws Exception;

    protected Date getUntilTime(AbstractSchedulerOperation.Definition definition) throws Exception {
        return definition.statement.existsParameter("Time") ? AbstractExecOperation.parseDate(definition.statement.getParameter("Time").getValue()) : null;
    }

    protected boolean isAutoExpire(AbstractSchedulerOperation.Definition definition) throws Exception {
        return definition.statement.existsModifier("AUTOEXPIRE");
    }

    @Override
    protected void raiseSLMessage(String message, MFSession session) {
        super.raiseSLMessage(message, session);
        Utils.sleep(10L);
    }

    @Override
    protected void raiseSLMessageError(String message, MFSession session) {
        super.raiseSLMessageError(message, session);
        Utils.sleep(10L);
    }

    protected void processError(Throwable exception, MFSession session) {
        this.raiseSLMessageError(Utils.formatException(exception, "\n       "), session);
        this.raiseSLMessage(null, session);
    }

    protected class ExecutionListenerImpl
    implements ExecutionListener {
        private MFSession session;
        private boolean withProgress;

        protected ExecutionListenerImpl(MFSession session, boolean withProgress) {
            this.session = session;
            this.withProgress = withProgress;
        }

        @Override
        public void onTaskListStarted(TaskList taskList, TaskListExecution execution) {
            AbstractExecOperation.this.raiseSLMessage("\nExecuting " + this.taskListName(taskList) + (this.isUnordered(execution) ? " (Unordered)" : "") + "...\n", this.session);
        }

        @Override
        public void onTaskListWaiting(TaskList taskList, TaskListExecution execution) {
            String message = execution.getTaskExecutions().stream().map(TaskExecution::getTaskName).map(taskName -> "\n   Inconsequential " + this.taskName((String)taskName) + " waiting for user completion...").collect(Collectors.joining());
            AbstractExecOperation.this.raiseSLMessage(message + "\n", this.session);
        }

        @Override
        public void onTaskListCompleted(TaskList taskList, TaskListExecution execution) {
            this.onTaskList(taskList, execution, "completed");
        }

        @Override
        public void onTaskListFailed(TaskList taskList, TaskListExecution execution) {
            this.onTaskList(taskList, execution, "failed");
        }

        @Override
        public void onTaskListExpired(TaskList taskList, TaskListExecution execution) {
            this.onTaskList(taskList, execution, "expired");
        }

        @Override
        public void onTaskListInterrupted(TaskList taskList, TaskListExecution execution) {
            this.onTaskList(taskList, execution, "interrupted");
        }

        @Override
        public void onTaskExecutionStarted(Task task, TaskListExecution execution) {
            String indent = execution.isAutoComplete() != false ? "   " : "      ";
            AbstractExecOperation.this.raiseSLMessage("\n" + indent + "Executing " + this.taskFullName(task, execution, false) + "...\n", this.session);
        }

        @Override
        public void onTaskExecutionCompleted(Task task, TaskListExecution execution) {
            this.onTaskExecution(task, execution, task.isAutoComplete() ? "autocompleted" : "completed", true);
        }

        @Override
        public void onTaskExecutionExpired(Task task, TaskListExecution execution) {
            this.onTaskExecution(task, execution, "expired", true);
        }

        @Override
        public void onTaskExecutionFailed(Task task, TaskListExecution execution) {
            this.onTaskExecution(task, execution, "failed", true);
        }

        @Override
        public void onTaskExecutionInterrupted(Task task, TaskListExecution execution) {
            this.onTaskExecution(task, execution, "interrupted", true);
        }

        @Override
        public void onTaskWaiting(Task task, TaskListExecution execution) {
            AbstractExecOperation.this.raiseSLMessage("\n   " + this.taskFullName(task, execution, true) + " waiting for user completion...\n", this.session);
        }

        @Override
        public void onTaskCompleted(Task task, TaskListExecution execution) {
            this.onTaskCompletion(task, execution, "user completed");
        }

        @Override
        public void onTaskFailed(Task task, TaskListExecution execution) {
            this.onTaskCompletion(task, execution, "failed");
        }

        @Override
        public void onTaskExpiredIncomplete(Task task, TaskListExecution execution) {
            this.onTaskCompletion(task, execution, "expired incomplete");
        }

        @Override
        public void onTaskInterruptedIncomplete(Task task, TaskListExecution execution) {
            this.onTaskCompletion(task, execution, "interrupted incomplete");
        }

        @Override
        public void onTaskUndone(Task task, TaskListExecution execution) {
            this.onTaskExecution(task, execution, "undone", false);
        }

        @Override
        public void onTaskDelayStarted(Task nextTask, TaskListExecution execution, long delay) {
            AbstractExecOperation.this.raiseSLMessage("\n   Delaying task execution (" + delay + " seconds)...", this.session);
        }

        @Override
        public void onTaskDelayCompleted(Task task, TaskListExecution execution) {
            AbstractExecOperation.this.raiseSLMessage(" done.\n", this.session);
        }

        @Override
        public void onTaskUndoDelayStarted(Task task, TaskListExecution execution, long delay) {
            AbstractExecOperation.this.raiseSLMessage("\n   Delaying after undo (" + delay + " seconds)...", this.session);
        }

        @Override
        public void onTaskUndoDelayCompleted(Task task, TaskListExecution execution) {
            AbstractExecOperation.this.raiseSLMessage(" done.\n", this.session);
        }

        @Override
        public void onExceptionTaskStarted(Task task, TaskListExecution execution) {
            AbstractExecOperation.this.raiseSLMessage("\n      Executing error handler for " + this.taskFullName(task, execution, false) + "...\n", this.session);
        }

        @Override
        public void onExceptionTaskCompleted(Task task, TaskListExecution execution) {
            this.onTaskExecution(task, execution, "completed", false);
        }

        @Override
        public void onExceptionTaskExpired(Task task, TaskListExecution execution) {
            this.onTaskExecution(task, execution, "expired", false);
        }

        @Override
        public void onExceptionTaskFailed(Task task, TaskListExecution execution) {
            this.onTaskExecution(task, execution, "failed", false);
        }

        @Override
        public void onExceptionTaskInterrupted(Task task, TaskListExecution execution) {
            this.onTaskExecution(task, execution, "interrupted", false);
        }

        @Override
        public void onRuleSetError(Task task, TaskListExecution execution) {
            AbstractExecOperation.this.raiseSLMessageError(task.getExecution().getErrorMessage(), this.session);
        }

        private void onTaskList(TaskList taskList, TaskListExecution execution, String action) {
            AbstractExecOperation.this.raiseSLMessage("\n" + this.taskListName(taskList) + " " + action + ".\n", this.session);
        }

        private void onTaskExecution(Task task, TaskListExecution execution, String action, boolean showProgress) {
            String indent = execution.isAutoComplete() != false ? "      " : "         ";
            AbstractExecOperation.this.raiseSLMessage(indent + "... " + StringUtils.toCapitalized(action) + this.formatTotalProgress(execution, showProgress), this.session);
        }

        private void onTaskCompletion(Task task, TaskListExecution execution, String action) {
            boolean showProgress;
            boolean bl = showProgress = task.getType() != TaskType.ACTION || !((ActionTask)task).hasScript();
            if (this.isUnorderedFullRun(execution)) {
                AbstractExecOperation.this.raiseSLMessage("\n   " + this.taskFullName(task, execution, true) + " " + action + this.formatTotalProgress(execution, showProgress), this.session);
            } else {
                AbstractExecOperation.this.raiseSLMessage("      ... " + StringUtils.toCapitalized(action) + this.formatTotalProgress(execution, showProgress), this.session);
            }
        }

        private String formatTotalProgress(TaskListExecution execution, boolean showProgress) {
            return this.withProgress && showProgress ? " (Total Progress " + AbstractTaskListOperation.formatWeight(execution.getTotalProgress(), true) + ").\n" : ".\n";
        }

        private String taskListName(TaskList taskList) {
            return "Task List '" + taskList.getName() + "'";
        }

        private String taskFullName(Task task, TaskListExecution execution, boolean isCapitalized) {
            return (String)(this.isFullRun(execution) ? this.taskType(execution, isCapitalized) + " " : "") + this.taskName(task);
        }

        private String taskType(TaskListExecution execution, boolean isCapitalized) {
            String result = this.isUnordered(execution) ? "inconsequential" : "consequential";
            return isCapitalized ? StringUtils.toCapitalized(result) : result;
        }

        private String taskName(Task task) {
            return this.taskName(task.getName());
        }

        private String taskName(String taskName) {
            return "Task '" + taskName + "'";
        }

        private boolean isUnordered(TaskListExecution execution) {
            return execution.isUnordered();
        }

        private boolean isUnorderedFullRun(TaskListExecution execution) {
            return this.isUnordered(execution) && this.isFullRun(execution);
        }

        private boolean isFullRun(TaskListExecution execution) {
            return execution.getExecutionMode() != ExecutionMode.TASK_DIRECT;
        }
    }
}

