/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.tasklist;

import com.streamscape.runtime.mf.operation.scheduler.tasklist.AbstractModifyTaskOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.Task;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskType;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

abstract class AbstractAddTaskOperation<T extends Task>
extends AbstractModifyTaskOperation<T> {
    protected AbstractAddTaskOperation(String operationName, TaskType taskType) {
        super(operationName, taskType);
        this.addAction();
        this.addModifiers();
        this.syntax.setDescription(this.doGetDescription());
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   TaskName    - Task name. If not specified, it will be automatically generated.\n   like        - Creates a new Task based on the existing Task.\n" + this.getMainParametersDescription("") + this.getSpecificParametersDescription() + this.getMetadataDescription(""));
        this.syntax.setExamples(this.getExamplePrefix() + "\n" + this.getExamplePrefix(false) + "\n" + this.getExamplePrefix() + " like TestList1.Task2\n" + this.getExamplePrefix() + " after start\n" + this.getExamplePrefix() + " after Task2\n" + this.getExamplePrefix() + " task window 60 seconds resume on (failed)\n" + this.getExamplePrefix() + " description 'Test task.' properties (name1 = 'value1') tags ('tag1')\n" + this.getExamplePrefix() + " weight 20\n" + this.getSpecificExamples());
    }

    protected void addAction() {
        this.syntax.setAction("ADD " + String.valueOf((Object)this.taskType) + " TASK").addActionParameter((SyntaxParameter)((IdentifierParameter)this.createTaskNameParameter().addExclusionValue("TO")).setRequired(false));
    }

    protected void addModifiers() {
        this.addToTaskListModifier();
        this.addLikeModifier();
        this.addDescriptionModifier();
        this.addTaskWindowModifier();
        this.addResumeOnModifier();
        this.addPropertiesModifier(false);
        this.addTagsModifier(false);
        this.addAfterTaskModifier(null);
        this.addWeightModifier();
        this.addOtherModifiers();
        this.addMetadataModifier();
    }

    protected abstract String doGetDescription();

    @Override
    protected String getPropertiesDescription(String indent) {
        return this.getPropertiesDescriptionForCreate(indent);
    }

    @Override
    protected String getTagsDescription(String indent) {
        return this.getTagsDescriptionForCreate(indent);
    }

    @Override
    protected String getExamplePrefix() {
        return this.getExamplePrefix(true);
    }

    protected String getExamplePrefix(boolean withTaskName) {
        return "add " + this.getTaskType() + " task" + (withTaskName ? " Task1" : "") + " to TestList";
    }

    @Override
    protected AbstractParameter createLikeParameter() {
        return (AbstractSchedulerOperation)this.new AbstractSchedulerOperation.FullTaskNameParameter("SourceList", "SourceTask", this.taskType);
    }

    protected abstract void addOtherModifiers();

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        TaskList taskList = AbstractAddTaskOperation.lookupTaskList(scheduler, definition);
        this.checkParameters(definition.statement, taskList);
        T task = this.addTask(taskList, definition.statement, session);
        AbstractAddTaskOperation.setAfterTask(taskList, task, definition);
        AbstractAddTaskOperation.setDescription(task, definition);
        AbstractAddTaskOperation.setTaskWindow(task, definition);
        AbstractAddTaskOperation.setResumeOn(task, definition);
        AbstractAddTaskOperation.setProperties(task, definition);
        AbstractAddTaskOperation.addTags(task, definition);
        AbstractAddTaskOperation.setWeight(task, definition);
        this.setOtherParameters(task, definition);
        AbstractAddTaskOperation.setMetadata(task, definition);
        scheduler.updateTaskList(taskList);
        return new SLResponse();
    }

    protected void checkParameters(DSLStatement statement, TaskList taskList) throws Exception {
    }

    protected abstract T addTask(TaskList var1, DSLStatement var2, MFSession var3) throws SchedulerException;

    protected abstract void setOtherParameters(T var1, AbstractSchedulerOperation.Definition var2) throws Exception;
}

