/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.metaset;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.scheduler.metaset.AbstractMetasetOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;

public class ListMetasetsOperation
extends AbstractMetasetOperation {
    public static final String NAME = "list metasets";

    public ListMetasetsOperation() {
        super(false);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST METASETS");
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Returns a list of Scheduler Metasets in the current node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   at node   - Returns a list of Metasets in the specified node.\n   at domain - Returns a list of Metasets in the sysplex.");
        this.syntax.setExamples("list metasets\nlist metasets at node Node1\nlist metasets at domain");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new AbstractSchedulerOperation.Definition(NAME, statement);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(AtNodeOrAtDomainModifier.getValue(((AbstractSchedulerOperation.Definition)statement).statement), statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Scheduler scheduler = this.getScheduler(session);
        AbstractDSLOperation.OperationResult result = new AbstractDSLOperation.OperationResult(ListMetasetsOperation.createResultDescriptor());
        for (Metaset metaset : scheduler.getMetasets()) {
            result.add(((RuntimeContext)this.callable).getName(), metaset.getName(), metaset.getAuthor(), ListMetasetsOperation.formatDate(metaset.getCreationTime()), this.getAssociatedTaskLists(scheduler, metaset), this.getAssociatedDataspaces(scheduler, metaset));
        }
        return result.getResponse();
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListMetasetsOperation.addColumn(result, "Node");
        ListMetasetsOperation.addColumn(result, "Name");
        ListMetasetsOperation.addColumn(result, "Author");
        ListMetasetsOperation.addColumn(result, "Created On");
        ListMetasetsOperation.addColumn(result, "Task Lists");
        ListMetasetsOperation.addColumn(result, "Dataspaces");
        return result;
    }
}

