/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.metaset;

import com.streamscape.runtime.mf.operation.scheduler.metaset.AbstractMetasetOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class DropMetasetOperation
extends AbstractMetasetOperation {
    public static final String NAME = "drop metaset";

    public DropMetasetOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.addAction("DROP METASET", true);
        this.syntax.setDescription("Drops a specified Scheduler Metaset.");
        this.syntax.setExamples("drop metaset Test");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new AbstractSchedulerOperation.Definition(NAME, statement);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        String metasetName;
        Scheduler scheduler = this.getScheduler(session);
        if (!scheduler.existsMetaset(metasetName = DropMetasetOperation.getMetasetName(((AbstractSchedulerOperation.Definition)statement).statement))) {
            throw new Exception("Metaset not found.");
        }
        this.getScheduler(session).dropMetaset(metasetName);
        return new SLResponse();
    }
}

