/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.metaset;

import com.streamscape.runtime.mf.operation.scheduler.metaset.AbstractMetasetOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.HashMap;

public class CreateMetasetOperation
extends AbstractMetasetOperation {
    public static final String NAME = "create metaset";

    public CreateMetasetOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.addAction("CREATE METASET", false);
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("IF NOT EXISTS", false).setName("IfNotExists")).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new Modifier("LIKE", false).addParameter(this.createLikeParameter()));
        this.addDescriptionModifier();
        this.syntax.addModifier(new Modifier("STATIC", false));
        this.syntax.addModifier(new BlockModifier("FACETS", "FacetsBlock", false).addModifier(this.wrapToRepeatable(this.createPropertyModifier(true, "                  "))));
        this.syntax.setDescription("Creates a new Metaset model with the specified name and parameters.\nUser can create multiple instances of the Metaset. All instances are independent of each other and of their model.\nMetaset model contains a set of predefined facets (name-value pairs). Each instance of the Metaset contains all\nthese predefined facets. Also, the user can add dynamic facets to this instance.\n\nMetaset can be created as static (it is not static by default).\nNon-static metaset allows the user to add or remove facets on its instances.\nStatic metaset only allows the user to change the values of existing predefined facets.\n\nMetasets created with default facets (tuples) consider such elements as 'pre-defined'.\nTheir data type is enforced and such elements may not be set to NULL values.\n\nIf users add facets using the API or commands after a Metaset is declared, such elements are considered 'dynamic'.\nUsers can set them to NULL values and check for existence or validity.\n\nMetaset facets are also referred to as Meta Keys and may be queried in a variety of ways,\nallowing for search and filtering of historical Task List execution data.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   if not exists - Suppresses an error if the specified metaset already exists and then does nothing.\n   like          - Creates a new metaset based on the existing metaset.\n   description   - Description of the metaset.\n   static        - Indicates that the metaset instances do not allow the addition or removal of facets.\n   facets        - List of the predefined facets (name-value pairs) of the metaset.\n                   Facet value can be a number, string or date (strings and dates must be in single quotes).\n                   Exact type must be specified for a facet and a default value can also be specified.\n                   Format can be specified for dates. If the date format is not specified,\n                   '" + SCHEDULER_DATE_FORMAT.toPattern() + "' is used by default.");
        this.syntax.setExamples("create metaset Test\ncreate metaset Test description 'Test metaset.'\ncreate metaset Test facets (key1 string 'Hello!', key2 int, key3 double 1.2)\ncreate metaset Test1 like Test facets (key4 boolean true) static\ncreate metaset Test1 if not exists facets (key5 long 123)\ncreate metaset Test1 facets(key1 date('yy/MM/dd') '01/01/01', key2 date '05-31-2022 08:31:12 PM')");
    }

    @Override
    protected AbstractParameter createLikeParameter() {
        return (AbstractParameter)new IdentifierParameter("SourceName").setCompletionAdviser(new AbstractSchedulerOperation.TaskListNameCompletionAdviser(this));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new AbstractSchedulerOperation.Definition(NAME, statement);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        DSLStatement dslStatement = ((AbstractSchedulerOperation.Definition)statement).statement;
        Scheduler scheduler = this.getScheduler(session);
        String metasetName = dslStatement.getParameter("MetasetName").getValue();
        if (!dslStatement.existsModifier("IfNotExists") || !scheduler.existsMetaset(metasetName)) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            if (dslStatement.existsParameter("SourceName")) {
                this.getPredefinedValues(this.doGetMetaset(scheduler, CreateMetasetOperation.getSourceName(dslStatement), "Source"), values);
            }
            this.addValues(dslStatement, values);
            CreateMetasetOperation.createMetaset(scheduler, dslStatement.getParameter("MetasetName").getValue(), dslStatement.existsParameter("Description") ? dslStatement.getParameter("Description").getValue() : null, values, dslStatement.existsModifier("STATIC"));
        }
        return new SLResponse();
    }
}

