/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.metaset;

import com.streamscape.runtime.mf.operation.scheduler.metaset.AbstractMetasetOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.BooleanParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.value.StatementSetValue;
import java.util.Map;

public class AlterMetasetOperation
extends AbstractMetasetOperation {
    public static final String NAME = "alter metaset";

    public AlterMetasetOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.addAction("ALTER METASET", true);
        this.addDescriptionModifier();
        this.syntax.addModifier((AbstractModifier)new Modifier("STATIC", false).addParameter(new BooleanParameter("Static")));
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("CLEAR FACETS"))).addModifier((AbstractModifier)new Modifier("REMOVE FACETS").addParameter(new SetParameter("RemoveFacets", new IdentifierParameter("Key")))));
        this.syntax.addModifier(new BlockModifier("ADD FACETS", "FacetsBlock", false).addModifier(this.wrapToRepeatable(this.createPropertyModifier(true, "                      "))));
        this.syntax.addModifier(new BlockModifier("SET FACETS", "SetFacetsBlock", false).setBrackets('{', '}').addModifier(this.wrapToRepeatable(new BlockModifier("", "SetFacetsInnerBlock").addModifier(this.createPropertyModifier(false)))));
        this.syntax.setDescription("Alters the specified Metaset with the specified parameters.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   description - Description of the metaset.\n   static      - Indicates if the metaset instances prohibit the addition or removal of keys.\n   facets      - List of the predefined facets of the metaset.\n                    add    - Adds the specified facets.\n                    remove - Removes the specified facets.\n                    clear  - Removes all facets.\n   set facets  - Changes the values of existing predefined facets of the metaset.");
        this.syntax.setExamples("alter metaset Test description 'Test metaset.'\nalter metaset Test add facets (key1 String 'Hello!', key2 int, key3 Double 1.2)\nalter metaset Test1 clear facets add facets (key1 int 5)\nalter metaset Test1 remove facets (key5)\nalter metaset Test1 set facets {(key1 1.5), (key2 5)}\nalter metaset Test1 remove facets (key5) add facets (key4 boolean true) set facets (key2 'Test!')\nalter metaset Test1 static");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        if (statement.getValuesCount() <= 2) {
            throw new ParsingException(this.getSyntaxErrorMessage("At least one parameter must be specified."));
        }
        return new AbstractSchedulerOperation.Definition(NAME, statement);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        DSLStatement dslStatement = ((AbstractSchedulerOperation.Definition)statement).statement;
        Scheduler scheduler = this.getScheduler(session);
        Metaset metaset = this.getMetaset(scheduler, definition);
        Map<String, Object> values = null;
        if (dslStatement.existsModifier("CLEAR FACETS") || dslStatement.existsModifier("REMOVE FACETS") || dslStatement.existsBlock("FacetsBlock") || dslStatement.existsBlock("SetFacetsBlock")) {
            values = metaset.getPredefinedProperties();
            if (dslStatement.existsModifier("CLEAR CLEAR")) {
                values.clear();
            }
            if (dslStatement.existsParameter("RemoveFacets")) {
                StatementSetValue set = dslStatement.getSet("RemoveFacets");
                for (int i = 0; i < set.size(); ++i) {
                    values.remove(set.getElement(i).getParameter("Key").getValue());
                }
            }
            this.changeValues(dslStatement, values);
            this.addValues(dslStatement, values);
        }
        AlterMetasetOperation.updateMetaset(scheduler, metaset.getName(), dslStatement.existsParameter("Description") ? dslStatement.getParameter("Description").getValue() : null, values, dslStatement.existsParameter("Static") ? Boolean.valueOf(Boolean.parseBoolean(dslStatement.getParameter("Static").getValue())) : null);
        return new SLResponse();
    }

    protected void changeValues(DSLStatement dslStatement, Map<String, Object> result) throws Exception {
        this.setValues(dslStatement, result, "DefaultValue", true);
    }
}

