/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.metaset;

import com.streamscape.ds.AbstractDataspace;
import com.streamscape.omf.java.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

abstract class AbstractMetasetOperation
extends AbstractSchedulerOperation {
    AbstractMetasetOperation(boolean isAdministrative) {
        super(isAdministrative);
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.metaset);
        this.syntax.setInitialVersion("3.8 Build 14");
    }

    protected void addAction(String action, boolean withAdviser) {
        IdentifierParameter name = this.createMetasetNameParameter();
        if (withAdviser) {
            name.setCompletionAdviser(new AbstractSchedulerOperation.MetasetNameCompletionAdviser(this));
        }
        this.syntax.setAction(action).addActionParameter(name);
    }

    protected Metaset getMetaset(Scheduler scheduler, AbstractSchedulerOperation.Definition definition) throws Exception {
        return this.doGetMetaset(scheduler, AbstractMetasetOperation.getMetasetName(definition.statement), null);
    }

    protected Metaset doGetMetaset(Scheduler scheduler, String name, String errorPrefix) throws Exception {
        Metaset result = scheduler.getMetaset(name);
        if (result == null) {
            throw new Exception((String)(errorPrefix != null ? errorPrefix + " metaset" : "Metaset") + " not found.");
        }
        return result;
    }

    protected List<String> getAssociatedTaskLists(Scheduler scheduler, Metaset metaset) {
        return scheduler.getTaskLists().stream().filter(tl -> Utils.equalsNullSafe(tl.getMetasetOID(), metaset.getOID())).map(tl -> tl.getName()).collect(Collectors.toList());
    }

    protected List<String> getAssociatedDataspaces(Scheduler scheduler, Metaset metaset) {
        return ((RuntimeContext)this.callable).getDataspaceManager().getDataspaces().stream().filter(ds -> Utils.equalsNullSafe(((AbstractDataspace)ds).getMetasetName(), metaset.getName())).map(FabricComponent::getName).collect(Collectors.toList());
    }

    protected void addValues(DSLStatement dslStatement, Map<String, Object> result) throws Exception {
        if (dslStatement.existsBlock("FacetsBlock")) {
            StatementBlockValue valuesBlock = dslStatement.getBlock("FacetsBlock");
            for (int i = 0; i < valuesBlock.getLinesCount(); ++i) {
                StatementValueList line = valuesBlock.getLineByIndex(i);
                String key = line.getParameter("Key").getValue();
                if (result.containsKey(key)) {
                    throw new Exception("Facet '" + key + "' already exists.");
                }
                AbstractDSLOperation.PropertyValue value = new AbstractDSLOperation.PropertyValue(line.existsParameter("DefaultValue") ? line.getParameter("DefaultValue").getValue() : null);
                this.parseTypeAndFormat(line, value);
                this.putValue(key, value, result);
            }
        }
    }
}

