/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.metaset;

import com.streamscape.runtime.mf.operation.scheduler.metaset.AbstractMetasetOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import java.util.stream.Collectors;

abstract class AbstractDescribeMetasetOperation
extends AbstractMetasetOperation {
    AbstractDescribeMetasetOperation(String operationName) {
        super(false);
        this.createDSLSyntax(operationName);
        this.addAction();
        this.addOptionalModifiers();
        this.syntax.setDescription(this.doGetDescription());
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   description - Shows a description of the Metaset.\n   facets      - Shows a list of facets of the Metaset.");
        this.syntax.setExamples(this.doGetExamples());
    }

    protected abstract void addAction();

    protected void addOptionalModifiers() {
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("DESCRIPTION"))).addModifier(new Modifier("FACETS"))).setCompactSyntax("{description | facets}"));
    }

    protected abstract String doGetDescription();

    protected abstract String doGetExamples();

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new AbstractSchedulerOperation.Definition(this.getName(), statement);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        Metaset metaset = this.getMetaset(scheduler, definition, session);
        RowSet rowSet = null;
        if (definition.statement.existsModifier("DESCRIPTION")) {
            rowSet = new RowSet(AbstractDescribeMetasetOperation.createResultDescriptorDescription());
            AbstractDescribeMetasetOperation.addValues(rowSet, AbstractDescribeMetasetOperation.skipNull(metaset.getDescription()));
        } else if (definition.statement.existsModifier("FACETS")) {
            rowSet = new RowSet(AbstractDescribeMetasetOperation.createResultDescriptorForValues());
            for (String key : metaset.listKeys().stream().sorted().collect(Collectors.toList())) {
                Object value = metaset.get(key);
                AbstractDSLOperation.PropertyValue.Type type = AbstractDSLOperation.PropertyValue.Type.resolveType(value);
                AbstractDescribeMetasetOperation.addValues(rowSet, key, type != null ? type.toPrintString() : "n/a", value);
            }
        } else {
            rowSet = new RowSet(AbstractDescribeMetasetOperation.createSimpleResultDescriptor());
            AbstractDescribeMetasetOperation.addValues(rowSet, "Name", metaset.getName());
            AbstractDescribeMetasetOperation.addValues(rowSet, "Author", metaset.getAuthor());
            AbstractDescribeMetasetOperation.addValues(rowSet, "Created On", AbstractDescribeMetasetOperation.formatDate(metaset.getCreationTime()));
            AbstractDescribeMetasetOperation.addValues(rowSet, "Last Modified On", AbstractDescribeMetasetOperation.formatDate(metaset.getLastUpdateTime()));
            AbstractDescribeMetasetOperation.addValues(rowSet, "Static", metaset.isStatic());
            this.addOtherGeneralParameters(scheduler, metaset, rowSet);
        }
        return new SLResponse(rowSet);
    }

    protected void addOtherGeneralParameters(Scheduler scheduler, Metaset metaset, RowSet rowSet) {
    }

    protected abstract Metaset getMetaset(Scheduler var1, AbstractSchedulerOperation.Definition var2, MFSession var3) throws Exception;

    private static RowMetaData createResultDescriptorForValues() {
        RowMetaData result = new RowMetaData();
        AbstractDescribeMetasetOperation.addColumn(result, "Key");
        AbstractDescribeMetasetOperation.addColumn(result, "Type");
        AbstractDescribeMetasetOperation.addColumn(result, "Value");
        return result;
    }
}

